/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.compiler.Compiler;
import com.github.leeonky.dal.format.Formatter;
import com.github.leeonky.dal.format.Type;
import com.github.leeonky.dal.format.Value;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.IllegalFieldException;
import com.github.leeonky.dal.runtime.IllegalTypeException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.Schema;
import com.github.leeonky.dal.runtime.SchemaAssertionFailure;
import com.github.leeonky.dal.type.AllowNull;
import com.github.leeonky.dal.type.Partial;
import com.github.leeonky.dal.type.SubType;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.PropertyReader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class SchemaVerifier {
    private final Data object;
    private final RuntimeContextBuilder.DALRuntimeContext DALRuntimeContext;
    private static final Compiler compiler = new Compiler();

    public SchemaVerifier(RuntimeContextBuilder.DALRuntimeContext DALRuntimeContext2, Data object) {
        this.DALRuntimeContext = DALRuntimeContext2;
        this.object = object;
    }

    private <T> BeanClass<T> getPolymorphicSchemaType(Class<?> superSchemaType) {
        Class type = superSchemaType;
        SubType subType = superSchemaType.getAnnotation(SubType.class);
        if (subType != null) {
            Object value = this.object.getValue(compiler.toChainNodes(subType.property())).getInstance();
            type = Stream.of(subType.types()).filter(t -> t.value().equals(value)).map(SubType.Type::type).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Cannot guess sub type through property type value[%s]", value)));
        }
        return BeanClass.create(type);
    }

    public boolean verify(Class<?> clazz, Object schemaInstance, String subPrefix) {
        Set<String> propertyReaderNames = this.object.getFieldNames();
        BeanClass schemaType = this.getPolymorphicSchemaType(clazz);
        Object schema = schemaInstance == null ? schemaType.newInstance(new Object[0]) : schemaInstance;
        return (clazz.getAnnotation(Partial.class) != null || this.noMoreUnexpectedField(schemaType, schemaType.getPropertyReaders().keySet(), propertyReaderNames)) && this.allMandatoryPropertyShouldBeExist(schemaType, propertyReaderNames) && this.allPropertyValueShouldBeValid(subPrefix, schemaType, schema) && this.schemaVerificationShouldPass(schema);
    }

    private boolean schemaVerificationShouldPass(Object schema) {
        if (schema instanceof Schema) {
            try {
                ((Schema)schema).verify(this.object);
            }
            catch (SchemaAssertionFailure schemaAssertionFailure) {
                return this.errorLog(schemaAssertionFailure.getMessage(), new Object[0]);
            }
        }
        return true;
    }

    private <T> boolean noMoreUnexpectedField(BeanClass<T> polymorphicBeanClass, Set<String> expectedFields, Set<String> actualFields) {
        return actualFields.stream().allMatch(f -> this.shouldNotContainsUnexpectedField(polymorphicBeanClass, expectedFields, (String)f));
    }

    private <T> boolean allMandatoryPropertyShouldBeExist(BeanClass<T> polymorphicBeanClass, Set<String> actualFields) {
        return polymorphicBeanClass.getPropertyReaders().values().stream().filter(propertyReader -> propertyReader.getAnnotation(AllowNull.class) == null).allMatch(propertyReader -> this.shouldContainsField(actualFields, polymorphicBeanClass, (PropertyReader)propertyReader));
    }

    private <T> boolean allPropertyValueShouldBeValid(String subPrefix, BeanClass<T> polymorphicBeanClass, T schemaInstance) {
        return polymorphicBeanClass.getPropertyReaders().values().stream().allMatch(propertyReader -> {
            Data wrappedPropertyValue = this.object.getValue(propertyReader.getName());
            return this.allowNullAndIsNull((PropertyReader)propertyReader, wrappedPropertyValue) || wrappedPropertyValue.createSchemaVerifier().verifySchemaInGenericType(subPrefix + "." + propertyReader.getName(), propertyReader.getType(), propertyReader.getValue(schemaInstance));
        });
    }

    private <T> boolean allowNullAndIsNull(PropertyReader<T> propertyReader, Data propertyValueWrapper) {
        return propertyReader.getAnnotation(AllowNull.class) != null && propertyValueWrapper.isNull();
    }

    private <T> boolean shouldNotContainsUnexpectedField(BeanClass<T> polymorphicBeanClass, Set<String> expectedFields, String f) {
        return expectedFields.contains(f) || this.errorLog("Unexpected field `%s` for schema %s[%s]", f, polymorphicBeanClass.getSimpleName(), polymorphicBeanClass.getName());
    }

    private <T> boolean shouldContainsField(Set<String> actualFields, BeanClass<T> polymorphicBeanClass, PropertyReader<T> propertyReader) {
        return actualFields.contains(propertyReader.getName()) || this.errorLog("Expecting field `%s` to be in type %s[%s], but does not exist", propertyReader.getName(), polymorphicBeanClass.getSimpleName(), polymorphicBeanClass.getName());
    }

    private boolean errorLog(String format, Object ... params) {
        throw new IllegalTypeException(String.format(format, params));
    }

    private boolean verifySchemaInGenericType(String subPrefix, BeanClass<?> type, Object schemaProperty) {
        Class fieldType = type.getType();
        if (Formatter.class.isAssignableFrom(fieldType)) {
            return this.verifyFormatterValue(subPrefix, this.getOrCreateFormatter(schemaProperty, type));
        }
        if (this.DALRuntimeContext.isSchemaRegistered(fieldType)) {
            return this.object.createSchemaVerifier().verify(fieldType, schemaProperty, subPrefix);
        }
        if (type.isCollection()) {
            return this.verifyCollection(subPrefix, type.getElementType(), schemaProperty);
        }
        if (Map.class.isAssignableFrom(fieldType)) {
            return this.verifyMap(subPrefix, type, (Map)schemaProperty);
        }
        if (Type.class.isAssignableFrom(fieldType)) {
            return this.verifyWrappedType(subPrefix, (Type)schemaProperty, type);
        }
        if (Value.class.isAssignableFrom(fieldType)) {
            return this.verifyWrappedValue(subPrefix, (Value)schemaProperty, type);
        }
        return this.verifyType(subPrefix, schemaProperty, fieldType);
    }

    private boolean verifyWrappedValue(String subPrefix, Value<Object> schemaProperty, BeanClass<?> genericType) {
        BeanClass type = genericType.getTypeArguments(0).orElse(null);
        if (schemaProperty != null) {
            return this.verifyByValue(subPrefix, schemaProperty, type);
        }
        if (type == null) {
            throw this.illegalStateException(subPrefix);
        }
        return this.verifyValueViaType(subPrefix, type.getType());
    }

    private boolean verifyValueViaType(String subPrefix, Class<?> rawType) {
        try {
            if (this.object.isNull()) {
                return this.errorLog("Can not convert null field `%s` to type [%s], use @AllowNull to verify nullable field", subPrefix, rawType.getName());
            }
            this.DALRuntimeContext.getConverter().convert(rawType, this.object.getInstance());
            return true;
        }
        catch (Exception ignore) {
            return this.errorLog("Can not convert field `%s` (%s: %s) to type [%s]", subPrefix, BeanClass.getClassName((Object)this.object.getInstance()), this.object.getInstance(), rawType.getName());
        }
    }

    private boolean verifyByValue(String subPrefix, Value<Object> schemaProperty, BeanClass<?> type) {
        try {
            return schemaProperty.verify(schemaProperty.convertAs(this.DALRuntimeContext, this.object.getInstance(), type)) || this.errorLog(schemaProperty.errorMessage(subPrefix, this.object.getInstance()), new Object[0]);
        }
        catch (IllegalFieldException ignore) {
            throw this.illegalStateException(subPrefix);
        }
    }

    private IllegalStateException illegalStateException(String subPrefix) {
        return new IllegalStateException(String.format("%s should specify generic type", subPrefix));
    }

    private boolean verifyWrappedType(String subPrefix, Type<Object> schemaProperty, BeanClass<?> genericType) {
        if (schemaProperty != null) {
            return schemaProperty.verify(this.object.getInstance()) || this.errorLog(schemaProperty.errorMessage(subPrefix, this.object.getInstance()), new Object[0]);
        }
        Class rawType = ((BeanClass)genericType.getTypeArguments(0).orElseThrow(() -> this.illegalStateException(subPrefix))).getType();
        return rawType.isInstance(this.object.getInstance()) || this.errorLog("Expecting field `%s` to be type [%s], but was [%s]", subPrefix, rawType.getName(), BeanClass.getClassName((Object)this.object.getInstance()));
    }

    private boolean verifyType(String subPrefix, Object schemaProperty, Class<?> fieldType) {
        if (schemaProperty != null) {
            return Objects.equals(schemaProperty, this.object.getInstance()) || this.errorLog("Expecting field `%s` to be %s[%s], but was %s[%s]", subPrefix, BeanClass.getClassName((Object)schemaProperty), schemaProperty, BeanClass.getClassName((Object)this.object.getInstance()), this.object.getInstance());
        }
        return fieldType.isInstance(this.object.getInstance()) || this.errorLog("Expecting field `%s` to be type [%s], but was [%s]", subPrefix, fieldType.getName(), BeanClass.getClassName((Object)this.object.getInstance()));
    }

    private boolean verifyCollection(String subPrefix, BeanClass<?> elementType, Object schemaProperties) {
        List<Data> dataList = this.object.getListObjects();
        if (schemaProperties == null) {
            return IntStream.range(0, dataList.size()).allMatch(i -> ((Data)dataList.get(i)).createSchemaVerifier().verifySchemaInGenericType(String.format("%s[%d]", subPrefix, i), elementType, null));
        }
        List schemaPropertyList = BeanClass.arrayCollectionToStream((Object)schemaProperties).collect(Collectors.toList());
        return this.shouldBeSameSize(subPrefix, dataList, schemaPropertyList) && IntStream.range(0, dataList.size()).allMatch(i -> ((Data)dataList.get(i)).createSchemaVerifier().verifySchemaInGenericType(String.format("%s[%d]", subPrefix, i), elementType, schemaPropertyList.get(i)));
    }

    private Formatter<Object, Object> getOrCreateFormatter(Object schemaProperty, BeanClass<?> genericType) {
        if (schemaProperty != null) {
            return (Formatter)schemaProperty;
        }
        Class fieldType = genericType.getType();
        return (Formatter)genericType.getTypeArguments(0).map(t -> BeanClass.newInstance((Class)fieldType, (Object[])new Object[]{t.getType()})).orElseGet(() -> BeanClass.newInstance((Class)fieldType, (Object[])new Object[0]));
    }

    private boolean verifyMap(String subPrefix, BeanClass<?> genericType, Map<?, Object> schemaProperty) {
        BeanClass subGenericType = (BeanClass)genericType.getTypeArguments(1).orElseThrow(() -> new IllegalArgumentException(String.format("`%s` should be generic type", subPrefix)));
        if (schemaProperty == null) {
            return this.object.getFieldNames().stream().allMatch(key -> this.object.getValue(key).createSchemaVerifier().verifySchemaInGenericType(subPrefix + "." + key, subGenericType, null));
        }
        return this.shouldBeSameSize(subPrefix, this.object.getFieldNames(), schemaProperty.values()) && this.object.getFieldNames().stream().allMatch(key -> this.object.getValue(key).createSchemaVerifier().verifySchemaInGenericType(subPrefix + "." + key, subGenericType, schemaProperty.get(key)));
    }

    private boolean shouldBeSameSize(String subPrefix, Collection<?> wrappedObjectList, Collection<?> schemaPropertyList) {
        return wrappedObjectList.size() == schemaPropertyList.size() || this.errorLog("Expecting field `%s` to be size [%d], but was size [%d]", subPrefix, schemaPropertyList.size(), wrappedObjectList.size());
    }

    private boolean verifyFormatterValue(String subPrefix, Formatter<Object, Object> formatter) {
        return formatter.isValid(this.object.getInstance()) || this.errorLog("Expecting field `%s` to be in `%s`, but was [%s]", subPrefix, formatter.getFormatterName(), this.object.getInstance());
    }
}

