/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.table;

import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.table.RowNode;
import com.github.leeonky.dal.ast.table.TableBody;
import com.github.leeonky.dal.ast.table.TableHead;
import com.github.leeonky.dal.ast.table.TransposedRowNode;
import com.github.leeonky.dal.ast.table.TransposedTableHead;
import com.github.leeonky.interpreter.InterpreterException;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TransposedTableBody
extends DALNode {
    private final List<TransposedRowNode> rows;

    public TransposedTableBody(List<DALNode> rows) {
        this.rows = rows.stream().map(TransposedRowNode.class::cast).collect(Collectors.toList());
    }

    public TransposedTableBody checkTable(TransposedTableHead tableHead) {
        this.checkCellSize(tableHead);
        this.replaceEmptyCell();
        this.transpose(tableHead);
        return this;
    }

    private void replaceEmptyCell() {
        this.rows.stream().skip(1L).forEach(row -> row.replaceEmptyCell(this.rows.get(0)));
    }

    private void checkCellSize(TransposedTableHead tableHead) {
        this.rows.forEach(tableHead::checkSize);
        Map<Integer, List<TransposedRowNode>> rowsByCount = this.rows.stream().collect(Collectors.groupingBy(TransposedRowNode::cellCount));
        if (rowsByCount.size() > 1) {
            throw new SyntaxException("Different cell size", new ArrayList<List<TransposedRowNode>>(rowsByCount.values()).get(1).get(0).getPositionBegin(), InterpreterException.Position.Type.LINE);
        }
    }

    public TableBody transpose(TransposedTableHead tableHead) {
        return new TableBody(this.rows.stream().map(rowNode -> rowNode.transpose(tableHead)).reduce(this::merge).orElse(Collections.emptyList()), InterpreterException.Position.Type.CHAR);
    }

    private List<RowNode> merge(final List<RowNode> rows1, final List<RowNode> rows2) {
        return new ArrayList<RowNode>(){
            {
                for (int i = 0; i < rows1.size(); ++i) {
                    this.add(((RowNode)rows1.get(i)).merge((RowNode)rows2.get(i)));
                }
            }
        };
    }

    public TableHead transposeHead() {
        return new TableHead(this.rows.stream().map(TransposedRowNode::getHeader).collect(Collectors.toList()));
    }

    @Override
    public String inspect() {
        return this.rows.stream().map(TransposedRowNode::inspect).collect(Collectors.joining("\n"));
    }
}

