/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.format;

import com.github.leeonky.dal.format.BaseFormatter;
import com.github.leeonky.dal.runtime.IllegalTypeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.format.DateTimeParseException;

public class Formatters {

    public static class Boolean
    extends BaseFormatter<java.lang.Boolean, java.lang.Boolean> {
        @Override
        public java.lang.Boolean convert(java.lang.Boolean input) {
            return input;
        }
    }

    public static class LocalDateTime
    extends BaseFormatter<java.lang.String, java.time.LocalDateTime> {
        @Override
        public java.time.LocalDateTime convert(java.lang.String input) {
            try {
                return java.time.LocalDateTime.parse(input);
            }
            catch (DateTimeParseException ignore) {
                throw new IllegalTypeException();
            }
        }
    }

    public static class LocalDate
    extends BaseFormatter<java.lang.String, java.time.LocalDate> {
        @Override
        public java.time.LocalDate convert(java.lang.String input) {
            try {
                return java.time.LocalDate.parse(input);
            }
            catch (DateTimeParseException ignore) {
                throw new IllegalTypeException();
            }
        }
    }

    public static class ZeroNumber
    extends BaseFormatter<java.lang.Number, java.lang.Integer> {
        @Override
        public java.lang.Integer convert(java.lang.Number input) {
            if (new BigDecimal(input.toString()).compareTo(BigDecimal.ZERO) != 0) {
                throw new IllegalTypeException();
            }
            return 0;
        }
    }

    public static class PositiveNumber
    extends BaseFormatter<java.lang.Number, BigDecimal> {
        @Override
        public BigDecimal convert(java.lang.Number input) {
            BigDecimal decimal = new BigDecimal(input.toString());
            if (decimal.compareTo(BigDecimal.ZERO) <= 0) {
                throw new IllegalTypeException();
            }
            return decimal;
        }
    }

    public static class Number
    extends BaseFormatter<java.lang.Number, BigDecimal> {
        public static Number equalTo(final java.lang.Number expect) {
            return new Number(){

                @Override
                public boolean isValidValue(BigDecimal value) {
                    return value.compareTo(new BigDecimal(expect.toString())) == 0;
                }

                @Override
                public java.lang.String getFormatterName() {
                    return java.lang.String.format("Number equal to [%s]", expect);
                }
            };
        }

        public static Number positive() {
            return Number.greaterThan(0);
        }

        public static Number greaterThan(final java.lang.Number expect) {
            return new Number(){

                @Override
                public boolean isValidValue(BigDecimal value) {
                    return value.compareTo(new BigDecimal(expect.toString())) > 0;
                }

                @Override
                public java.lang.String getFormatterName() {
                    return java.lang.String.format("Number greater than [%s]", expect);
                }
            };
        }

        public static Number negative() {
            return Number.lessThan(0);
        }

        public static Number lessThan(final java.lang.Number expect) {
            return new Number(){

                @Override
                public boolean isValidValue(BigDecimal value) {
                    return value.compareTo(new BigDecimal(expect.toString())) < 0;
                }

                @Override
                public java.lang.String getFormatterName() {
                    return java.lang.String.format("Number less than [%s]", expect);
                }
            };
        }

        public static Number greaterOrEqualTo(final java.lang.Number expect) {
            return new Number(){

                @Override
                public boolean isValidValue(BigDecimal value) {
                    return value.compareTo(new BigDecimal(expect.toString())) >= 0;
                }

                @Override
                public java.lang.String getFormatterName() {
                    return java.lang.String.format("Number greater or equal to [%s]", expect);
                }
            };
        }

        public static Number lessOrEqualTo(final java.lang.Number expect) {
            return new Number(){

                @Override
                public boolean isValidValue(BigDecimal value) {
                    return value.compareTo(new BigDecimal(expect.toString())) <= 0;
                }

                @Override
                public java.lang.String getFormatterName() {
                    return java.lang.String.format("Number less or equal to [%s]", expect);
                }
            };
        }

        @Override
        public BigDecimal convert(java.lang.Number input) {
            return new BigDecimal(input.toString());
        }
    }

    public static class Enum<T extends java.lang.Enum<T>>
    extends BaseFormatter<java.lang.String, T> {
        private final Class<T> enumType;

        public Enum() {
            this(null);
        }

        public Enum(Class<T> enumType) {
            this.enumType = enumType;
        }

        @Override
        public T convert(java.lang.String input) {
            return this.enumType == null ? this.defaultVerification(input) : this.verifyViaEnumType(input);
        }

        private T verifyViaEnumType(java.lang.String input) {
            try {
                return java.lang.Enum.valueOf(this.enumType, input);
            }
            catch (Exception e) {
                throw new IllegalTypeException();
            }
        }

        private T defaultVerification(java.lang.String input) {
            if (input.chars().filter(Character::isLetter).anyMatch(Character::isLowerCase)) {
                throw new IllegalTypeException();
            }
            return null;
        }
    }

    public static class URL
    extends BaseFormatter<java.lang.String, java.net.URL> {
        @Override
        public java.net.URL convert(java.lang.String input) {
            return BaseFormatter.toValueOrThrowIllegalTypeException(input, java.net.URL::new);
        }
    }

    public static class Integer
    extends BaseFormatter<java.lang.Number, BigInteger> {
        public static Integer equalTo(final long expect) {
            return new Integer(){

                @Override
                public boolean isValidValue(BigInteger value) {
                    return value.compareTo(BigInteger.valueOf(expect)) == 0;
                }

                @Override
                public java.lang.String getFormatterName() {
                    return java.lang.String.format("Integer equal to [%d]", expect);
                }
            };
        }

        public static Integer positive() {
            return Integer.greaterThan(0L);
        }

        public static Integer greaterThan(final long expect) {
            return new Integer(){

                @Override
                public boolean isValidValue(BigInteger value) {
                    return value.compareTo(BigInteger.valueOf(expect)) > 0;
                }

                @Override
                public java.lang.String getFormatterName() {
                    return java.lang.String.format("Integer greater than [%d]", expect);
                }
            };
        }

        public static Integer lessThan(final long expect) {
            return new Integer(){

                @Override
                public boolean isValidValue(BigInteger value) {
                    return value.compareTo(BigInteger.valueOf(expect)) < 0;
                }

                @Override
                public java.lang.String getFormatterName() {
                    return java.lang.String.format("Integer less than [%d]", expect);
                }
            };
        }

        public static Integer negative() {
            return Integer.lessThan(0L);
        }

        public static Integer greaterOrEqualTo(final long expect) {
            return new Integer(){

                @Override
                public boolean isValidValue(BigInteger value) {
                    return value.compareTo(BigInteger.valueOf(expect)) >= 0;
                }

                @Override
                public java.lang.String getFormatterName() {
                    return java.lang.String.format("Integer greater or equal to [%d]", expect);
                }
            };
        }

        public static Integer lessOrEqualTo(final long expect) {
            return new Integer(){

                @Override
                public boolean isValidValue(BigInteger value) {
                    return value.compareTo(BigInteger.valueOf(expect)) <= 0;
                }

                @Override
                public java.lang.String getFormatterName() {
                    return java.lang.String.format("Integer less or equal to [%d]", expect);
                }
            };
        }

        @Override
        public BigInteger convert(java.lang.Number input) {
            if (input instanceof Double || input instanceof Float || input instanceof BigDecimal && ((BigDecimal)input).scale() != 0) {
                throw new IllegalTypeException();
            }
            return new BigInteger(input.toString());
        }
    }

    public static class PositiveInteger
    extends Integer {
        @Override
        public BigInteger convert(java.lang.Number input) {
            BigInteger value = super.convert(input);
            if (value.compareTo(BigInteger.ZERO) <= 0) {
                throw new IllegalTypeException();
            }
            return value;
        }
    }

    public static class Instant
    extends BaseFormatter<java.lang.String, java.time.Instant> {
        public static Instant now(final int errorMs) {
            return new Instant(){
                private java.time.Instant now;

                @Override
                public boolean isValidValue(java.time.Instant actual) {
                    this.now = java.time.Instant.now();
                    return actual.isAfter(this.now.plusMillis(-errorMs)) && actual.isBefore(this.now.plusMillis(errorMs));
                }

                @Override
                public java.lang.String getFormatterName() {
                    return java.lang.String.format("Instant now[%s] +/- %dms", this.now, errorMs);
                }
            };
        }

        public static Instant now() {
            return Instant.now(10000);
        }

        @Override
        public java.time.Instant convert(java.lang.String input) {
            return BaseFormatter.toValueOrThrowIllegalTypeException(input, java.time.Instant::parse);
        }
    }

    @Deprecated
    public static class String
    extends BaseFormatter<java.lang.String, java.lang.String> {
        @Override
        public java.lang.String convert(java.lang.String input) {
            return input;
        }
    }
}

