/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal;

import com.github.leeonky.dal.DALFactory;
import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.compiler.Compiler;
import com.github.leeonky.dal.compiler.Notations;
import com.github.leeonky.dal.runtime.AssertResult;
import com.github.leeonky.dal.runtime.Extension;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.SourceCode;
import com.github.leeonky.interpreter.SyntaxException;
import com.github.leeonky.util.BeanClass;
import java.util.List;
import java.util.stream.Collectors;

public class DAL {
    private final Compiler compiler = new Compiler();
    private final RuntimeContextBuilder runtimeContextBuilder = new RuntimeContextBuilder();
    private static DAL instance;

    public static DAL getInstance() {
        if (instance == null) {
            instance = DALFactory.create();
        }
        return instance;
    }

    public RuntimeContextBuilder getRuntimeContextBuilder() {
        return this.runtimeContextBuilder;
    }

    @Deprecated
    public AssertResult assertTrue(Object actual, String expression) {
        Object result = this.evaluate(actual, expression);
        if (result instanceof Boolean) {
            return (Boolean)result != false ? AssertResult.passedResult() : AssertResult.failedResult(actual, expression);
        }
        throw new IllegalStateException("Verification result should be boolean but '" + BeanClass.getClassName(result) + "'");
    }

    public <T> List<T> evaluateAll(Object input, String expressions) {
        RuntimeContextBuilder.DALRuntimeContext DALRuntimeContext2 = this.runtimeContextBuilder.build(input);
        return this.compiler.compile(SourceCode.createSourceCode(expressions, Notations.LINE_COMMENTS), DALRuntimeContext2).stream().map(node -> node.evaluate(DALRuntimeContext2)).collect(Collectors.toList());
    }

    public <T> T evaluate(Object input, String expression) {
        RuntimeContextBuilder.DALRuntimeContext DALRuntimeContext2 = this.runtimeContextBuilder.build(input);
        List<DALNode> nodes = this.compiler.compile(SourceCode.createSourceCode(expression, Notations.LINE_COMMENTS), DALRuntimeContext2);
        if (nodes.size() > 1) {
            throw new SyntaxException("more than one expression", nodes.get(1).getPositionBegin());
        }
        return (T)nodes.get(0).evaluate(DALRuntimeContext2);
    }

    public DAL extend() {
        BeanClass.subTypesOf(Extension.class, (String)"com.github.leeonky.dal.extensions").forEach(c -> ((Extension)BeanClass.newInstance((Class)c, (Object[])new Object[0])).extend(this));
        return this;
    }
}

