/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.AssertionFailure;
import com.github.leeonky.dal.ast.DALExpression;
import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.DALOperator;
import com.github.leeonky.dal.ast.InputNode;
import com.github.leeonky.dal.ast.ListEllipsisNode;
import com.github.leeonky.dal.ast.SortSequenceNode;
import com.github.leeonky.dal.ast.SymbolNode;
import com.github.leeonky.dal.runtime.DalException;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ElementAssertionFailure;
import com.github.leeonky.dal.runtime.RowAssertionFailure;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.interpreter.Clause;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class ListScopeNode
extends DALNode {
    private List<DALNode> expressions__;
    private List<DALNode> inputExpressions;
    private List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> expressionFactories;
    private final Type type;
    private final boolean multiLineList;
    private final Comparator<Object> listComparator;

    public ListScopeNode(List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> expressionFactories, boolean multiLineList, Comparator<Object> listComparator) {
        this.type = this.guessType(expressionFactories);
        this.expressionFactories = expressionFactories;
        this.multiLineList = multiLineList;
        this.listComparator = listComparator;
    }

    public ListScopeNode(List<DALNode> inputExpressions, boolean multiLineList, Type type, Comparator<Object> listComparator) {
        this.inputExpressions = new ArrayList<DALNode>(inputExpressions);
        this.expressions__ = this.inputExpressions;
        this.multiLineList = multiLineList;
        this.type = type;
        this.listComparator = listComparator;
    }

    public ListScopeNode(List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> expressionFactories) {
        this(expressionFactories, false, SortSequenceNode.NOP_COMPARATOR);
    }

    private List<DALNode> getExpressions(int firstIndex) {
        return this.expressions__ != null ? this.expressions__ : this.getInputExpressions(firstIndex).stream().filter(node -> !(node instanceof ListEllipsisNode)).collect(Collectors.toList());
    }

    private List<DALNode> getInputExpressions(final int firstIndex) {
        if (this.inputExpressions != null) {
            return this.inputExpressions;
        }
        return new ArrayList<DALNode>(){
            {
                for (int i = 0; i < ListScopeNode.this.expressionFactories.size(); ++i) {
                    this.add(((Clause)ListScopeNode.this.expressionFactories.get(i)).expression(new DALExpression(InputNode.INSTANCE, new DALOperator.PropertyImplicit(), new SymbolNode(ListScopeNode.this.type.indexOfNode(firstIndex, i, ListScopeNode.this.expressionFactories.size()), SymbolNode.Type.BRACKET))));
                }
            }
        };
    }

    private Type guessType(List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> expressionFactories) {
        List isListEllipsis = expressionFactories.stream().map(this::isListEllipsis).collect(Collectors.toList());
        long ellipsesCount = isListEllipsis.stream().filter(Boolean::booleanValue).count();
        if (ellipsesCount > 0L) {
            if (ellipsesCount == 1L) {
                if (((Boolean)isListEllipsis.get(0)).booleanValue()) {
                    return Type.LAST_N_ITEMS;
                }
                if (((Boolean)isListEllipsis.get(isListEllipsis.size() - 1)).booleanValue()) {
                    return Type.FIRST_N_ITEMS;
                }
            } else if (ellipsesCount == 2L && ((Boolean)isListEllipsis.get(0)).booleanValue() && ((Boolean)isListEllipsis.get(isListEllipsis.size() - 1)).booleanValue()) {
                return Type.CONTAINS;
            }
            throw new SyntaxException("Invalid ellipsis", ((DALNode)expressionFactories.get(isListEllipsis.lastIndexOf(true)).expression(null)).getOperandPosition());
        }
        return Type.ALL_ITEMS;
    }

    @Override
    public String inspect() {
        if (this.type == Type.CONTAINS) {
            return this.expressionFactories.stream().map(clause -> ((DALNode)clause.expression(InputNode.INSTANCE)).inspect()).collect(Collectors.joining(", ", "[", "]"));
        }
        return this.getInputExpressions(0).stream().map(DALNode::inspect).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    protected boolean verify(Data actual, DALOperator.Equal operator, RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        return this.verifyAll(context, actual);
    }

    @Override
    protected boolean verify(Data actual, DALOperator.Matcher operator, RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        return this.verifyAll(context, actual);
    }

    private boolean verifyAll(RuntimeContextBuilder.DALRuntimeContext context, Data data) {
        if (!data.isList()) {
            throw new RuntimeException(String.format("Cannot compare %sand list", data.inspect()), this.getPositionBegin());
        }
        data.setListComparator(this.listComparator);
        int listFirstIndex = data.getListFirstIndex();
        if (this.type == Type.CONTAINS) {
            int elementIndex = 0;
            List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> subList = this.expressionFactories.subList(1, this.expressionFactories.size() - 1);
            for (int clauseIndex = 0; clauseIndex < subList.size(); ++clauseIndex) {
                Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode> clause = subList.get(clauseIndex);
                while (!this.verifyContains(clauseIndex, context, data, elementIndex++, clause, listFirstIndex)) {
                }
            }
            return true;
        }
        List<DALNode> expressions = this.getExpressions(listFirstIndex);
        if (this.type == Type.ALL_ITEMS) {
            AssertionFailure.assertListSize(expressions.size(), data.getListSize(), this.getPositionBegin());
        }
        return context.newBlockScope(data, () -> this.assertElementExpressions(context, expressions));
    }

    private boolean verifyContains(int clauseIndex, RuntimeContextBuilder.DALRuntimeContext context, Data data, int index, Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode> clause, int listFirstIndex) {
        if (index == data.getListSize()) {
            int operandPosition = clause.expression(InputNode.INSTANCE).getOperandPosition();
            throw this.multiLineList ? new RowAssertionFailure(clauseIndex, new AssertionFailure("No such element", operandPosition)) : new AssertionFailure("No such element", operandPosition);
        }
        try {
            return context.newBlockScope(data, () -> (boolean)((Boolean)((DALNode)clause.expression(new DALExpression(InputNode.INSTANCE, new DALOperator.PropertyImplicit(), new SymbolNode(index + listFirstIndex, SymbolNode.Type.BRACKET)))).evaluate(context)));
        }
        catch (AssertionFailure ignore) {
            return false;
        }
    }

    private boolean assertElementExpressions(RuntimeContextBuilder.DALRuntimeContext context, List<DALNode> expressions) {
        if (this.multiLineList) {
            for (int i = 0; i < expressions.size(); ++i) {
                DALNode expression2 = expressions.get(i);
                try {
                    expression2.evaluate(context);
                    continue;
                }
                catch (DalException dalException) {
                    throw new ElementAssertionFailure(i, dalException);
                }
            }
        } else {
            expressions.forEach(expression -> expression.evaluate(context));
        }
        return true;
    }

    private boolean isListEllipsis(Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode> clause) {
        return clause.expression(null) instanceof ListEllipsisNode;
    }

    public static enum Type {
        ALL_ITEMS,
        FIRST_N_ITEMS,
        LAST_N_ITEMS{

            @Override
            int indexOfNode(int firstIndex, int index, int count) {
                return index - count;
            }
        }
        ,
        CONTAINS;


        int indexOfNode(int firstIndex, int index, int count) {
            return index + firstIndex;
        }
    }
}

