/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.DALOperator;
import com.github.leeonky.dal.ast.table.RowNode;
import com.github.leeonky.dal.ast.table.TableBody;
import com.github.leeonky.dal.ast.table.TableHead;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RowAssertionFailure;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import java.util.List;
import java.util.stream.Collectors;

public class TableNode
extends DALNode {
    private final TableHead tableHead;
    private final TableBody tableBody;

    public TableNode(TableHead tableHead, TableBody tableBody) {
        this.tableHead = tableHead;
        this.tableBody = tableBody.checkTable(this.tableHead);
        this.setPositionBegin(tableHead.getPositionBegin());
    }

    @Override
    protected boolean verify(Data actual, DALOperator.Equal operator, RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        try {
            return this.transformToVerificationNode(actual, operator, context).verify(actual, operator, context, actualNode);
        }
        catch (RowAssertionFailure rowAssertionFailure) {
            throw rowAssertionFailure.linePositionException(this);
        }
    }

    @Override
    protected boolean verify(Data actual, DALOperator.Matcher operator, RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        try {
            return this.transformToVerificationNode(actual, operator, context).verify(actual, operator, context, actualNode);
        }
        catch (RowAssertionFailure rowAssertionFailure) {
            throw rowAssertionFailure.linePositionException(this);
        }
    }

    public DALNode transformToVerificationNode(Data actual, DALOperator operator, RuntimeContextBuilder.DALRuntimeContext context) {
        return (DALNode)this.tableBody.transformToListScope(actual, operator, this.tableHead.collectComparator(context)).setPositionBegin(this.getPositionBegin());
    }

    @Override
    public String inspect() {
        return this.tableHead.inspect() + this.tableBody.inspect();
    }

    public static String printLine(List<? extends DALNode> nodes) {
        return nodes.stream().map(DALNode::inspect).collect(Collectors.joining(" | ", "| ", " |"));
    }

    public RowNode getDataRowByDataIndex(int row) {
        return this.tableBody.getDataRowByDataIndex(row);
    }
}

