/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.table;

import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.DALOperator;
import com.github.leeonky.dal.ast.ListEllipsisNode;
import com.github.leeonky.dal.ast.ObjectScopeNode;
import com.github.leeonky.dal.ast.TableNode;
import com.github.leeonky.dal.ast.WildcardNode;
import com.github.leeonky.dal.ast.table.RowKeyType;
import com.github.leeonky.dal.ast.table.RowPrefixNode;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.Clause;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RowNode
extends DALNode {
    private final List<DALNode> cells;
    private final RowPrefixNode rowPrefix;

    public RowNode(DALNode prefix, DALNode cell) {
        this(prefix, Collections.singletonList(cell));
    }

    public RowNode(DALNode prefix, List<DALNode> cells) {
        this.rowPrefix = (RowPrefixNode)prefix;
        this.cells = new ArrayList<DALNode>(cells);
        this.setPositionBegin(cells.get(cells.size() - 1).getOperandPosition());
    }

    @Override
    public String inspect() {
        String prefix = this.rowPrefix.inspect();
        String data = TableNode.printLine(this.cells);
        return "\n" + (prefix.isEmpty() ? data : prefix + " " + data);
    }

    public Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode> verificationClause(DALOperator operator, RowKeyType rowKeyType) {
        return input -> this.isEllipsis() ? this.firstCell() : this.rowPrefix.indexAndSchema(rowKeyType, (DALNode)input, operator, this.isRowWildcard() ? this.firstCell() : (DALNode)new ObjectScopeNode(this.cells).setPositionBegin(this.firstCell().getOperandPosition()));
    }

    private DALNode firstCell() {
        return this.cells.get(0);
    }

    private boolean isRowWildcard() {
        return this.cells.size() >= 1 && this.firstCell() instanceof WildcardNode;
    }

    private boolean isEllipsis() {
        return this.cells.size() >= 1 && this.firstCell() instanceof ListEllipsisNode;
    }

    public List<DALNode> getCells() {
        return this.cells;
    }

    public RowNode merge(final RowNode rowNode) {
        return (RowNode)new RowNode((DALNode)this.rowPrefix, (List<DALNode>)new ArrayList<DALNode>(){
            {
                this.addAll(RowNode.this.cells);
                this.addAll(rowNode.cells);
            }
        }).setPositionBegin(this.getPositionBegin());
    }

    public boolean isData() {
        return !this.isEllipsis();
    }

    public boolean specialRow() {
        return this.isEllipsis() || this.isRowWildcard();
    }

    public RowKeyType combineRowKey(RowKeyType rowKeyType) {
        return rowKeyType.merge(this.rowPrefix.getRowKeyType());
    }
}

