/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.table;

import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.ListEllipsisNode;
import com.github.leeonky.dal.ast.TableNode;
import com.github.leeonky.dal.ast.WildcardNode;
import com.github.leeonky.dal.ast.table.EmptyCellNode;
import com.github.leeonky.dal.ast.table.HeaderNode;
import com.github.leeonky.dal.ast.table.RowNode;
import com.github.leeonky.dal.ast.table.TransposedTableHead;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TransposedRowNode
extends DALNode {
    private final HeaderNode headerNode;
    private final List<DALNode> cells;

    public TransposedRowNode(DALNode header, List<DALNode> cells) {
        this.headerNode = (HeaderNode)header;
        this.cells = cells;
        this.setPositionBegin(header.getPositionBegin());
    }

    @Override
    public String inspect() {
        return TableNode.printLine((List<? extends DALNode>)new ArrayList<DALNode>(){
            {
                this.add(TransposedRowNode.this.headerNode);
                this.addAll(TransposedRowNode.this.cells);
            }
        });
    }

    public List<RowNode> transpose(final TransposedTableHead transposedTableHead) {
        return new ArrayList<RowNode>(){
            {
                for (int i = 0; i < TransposedRowNode.this.cells.size(); ++i) {
                    this.add(new RowNode((DALNode)transposedTableHead.getPrefix(i), Collections.singletonList(TransposedRowNode.this.cells.get(i))));
                }
            }
        };
    }

    public HeaderNode getHeader() {
        return this.headerNode;
    }

    public int cellCount() {
        return this.cells.size();
    }

    public void replaceEmptyCell(TransposedRowNode transposedRowNode) {
        for (int i = 0; i < transposedRowNode.cells.size(); ++i) {
            DALNode row = transposedRowNode.cells.get(i);
            if (!(row instanceof WildcardNode) && !(row instanceof ListEllipsisNode)) continue;
            this.cells.set(i, new EmptyCellNode());
        }
    }
}

