/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.dal.ast.ConstNode;
import com.github.leeonky.dal.ast.DALExpression;
import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.DALOperator;
import com.github.leeonky.dal.ast.GroupNode;
import com.github.leeonky.dal.ast.InputNode;
import com.github.leeonky.dal.ast.ListEllipsisNode;
import com.github.leeonky.dal.ast.ListMappingNode;
import com.github.leeonky.dal.ast.ListScopeNode;
import com.github.leeonky.dal.ast.ObjectScopeNode;
import com.github.leeonky.dal.ast.PropertyPattern;
import com.github.leeonky.dal.ast.PropertyThis;
import com.github.leeonky.dal.ast.SortNode;
import com.github.leeonky.dal.ast.SortSequenceNode;
import com.github.leeonky.dal.ast.TableNode;
import com.github.leeonky.dal.ast.TransposedTableNode;
import com.github.leeonky.dal.ast.WildcardNode;
import com.github.leeonky.dal.ast.table.EmptyTransposedTableHead;
import com.github.leeonky.dal.ast.table.HeaderNode;
import com.github.leeonky.dal.ast.table.RowNode;
import com.github.leeonky.dal.ast.table.RowPrefixNode;
import com.github.leeonky.dal.ast.table.TableBody;
import com.github.leeonky.dal.ast.table.TableHead;
import com.github.leeonky.dal.ast.table.TransposedRowNode;
import com.github.leeonky.dal.ast.table.TransposedTableBody;
import com.github.leeonky.dal.ast.table.TransposedTableHead;
import com.github.leeonky.dal.compiler.Constants;
import com.github.leeonky.dal.compiler.DALProcedure;
import com.github.leeonky.dal.compiler.Notations;
import com.github.leeonky.dal.compiler.Tokens;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.Clause;
import com.github.leeonky.interpreter.ClauseParser;
import com.github.leeonky.interpreter.EscapeChars;
import com.github.leeonky.interpreter.FunctionUtil;
import com.github.leeonky.interpreter.IfThenFactory;
import com.github.leeonky.interpreter.NodeParser;
import com.github.leeonky.interpreter.Notation;
import com.github.leeonky.interpreter.OperatorParser;
import com.github.leeonky.interpreter.Parser;
import com.github.leeonky.interpreter.Procedure;
import com.github.leeonky.interpreter.SourceCode;
import com.github.leeonky.interpreter.Syntax;
import com.github.leeonky.interpreter.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Compiler {
    private static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> DEFAULT_OPERATOR = Procedure::currentOperator;
    private static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> IS = Notations.Operators.IS.operator(DALOperator.Is::new);
    private static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> WHICH = Notations.Operators.WHICH.operator(DALOperator.Which::new);
    private static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> PROPERTY_DOT = Notations.Operators.DOT.operator(DALOperator.PropertyDot::new, FunctionUtil.not(DALProcedure::mayBeElementEllipsis));
    private static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> MAYBE_PROPERTY_SLASH = Notations.Operators.SLASH.operator(DALOperator.PropertySlash::new);
    private static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> PROPERTY_SLASH = procedure -> procedure.isEnableSlashProperty() ? MAYBE_PROPERTY_SLASH.parse((DALProcedure)procedure) : Optional.empty();
    private static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> PROPERTY_IMPLICIT = procedure -> Optional.of(new DALOperator.PropertyImplicit());
    private static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> BINARY_ARITHMETIC_OPERATORS = (OperatorParser)Parser.oneOf((Parser[])new OperatorParser[]{Notations.Operators.AND.operator(DALOperator::operatorAnd), Notations.Operators.OR.operator(DALOperator::operatorOr), Notations.Keywords.AND.keywordOperator(DALOperator::keywordAnd, Constants.PROPERTY_DELIMITER_STRING), Notations.Operators.COMMA.operator(DALOperator::commaAnd, DALProcedure::isEnableCommaAnd), Notations.Operators.NOT_EQUAL.operator(DALOperator.NotEqual::new), Notations.Keywords.OR.keywordOperator(DALOperator::keywordOr, Constants.PROPERTY_DELIMITER_STRING), Notations.Operators.GREATER_OR_EQUAL.operator(DALOperator.GreaterOrEqual::new), Notations.Operators.LESS_OR_EQUAL.operator(DALOperator.LessOrEqual::new), Notations.Operators.GREATER.operator(DALOperator.Greater::new), Notations.Operators.LESS.operator(DALOperator.Less::new, FunctionUtil.not(DALProcedure::mayBeOpeningGroup)), Notations.Operators.PLUS.operator(DALOperator.Plus::new), Notations.Operators.SUBTRACTION.operator(DALOperator.Subtraction::new), Notations.Operators.MULTIPLICATION.operator(DALOperator.Multiplication::new), Notations.Operators.DIVISION.operator(DALOperator.Division::new)});
    private static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> UNARY_OPERATORS = (OperatorParser)Parser.oneOf((Parser[])new OperatorParser[]{Notations.Operators.MINUS.operator(DALOperator.Minus::new, FunctionUtil.not(DALProcedure::isCodeBeginning)), Notations.Operators.PLUS.operator(DALOperator.Positive::new, FunctionUtil.not(DALProcedure::isCodeBeginning)), Notations.Operators.NOT.operator(DALOperator.Not::new, FunctionUtil.not(DALProcedure::mayBeUnEqual))});
    private static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> VERIFICATION_OPERATORS = (OperatorParser)Parser.oneOf((Parser[])new OperatorParser[]{Notations.Operators.MATCHER.operator(DALOperator.Matcher::new), Notations.Operators.EQUAL.operator(DALOperator.Equal::new)});
    private static final OperatorParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> DEFAULT_VERIFICATION_OPERATOR = (OperatorParser.Mandatory)DEFAULT_OPERATOR.mandatory("");
    private static final EscapeChars SINGLE_QUOTED_ESCAPES = new EscapeChars().escape("\\\\", '\\').escape("\\'", '\'');
    private static final EscapeChars DOUBLE_QUOTED_ESCAPES = new EscapeChars().escape("\\\\", '\\').escape("\\n", '\n').escape("\\r", '\r').escape("\\t", '\t').escape("\\\"", '\"');
    private static final EscapeChars REGEX_ESCAPES = new EscapeChars().escape("\\/", '/');
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> PROPERTY;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> OBJECT;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> LIST;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> PARENTHESES;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> VERIFICATION_SPECIAL_OPERAND;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> VERIFICATION_VALUE_OPERAND;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> TABLE;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SHORT_VERIFICATION_OPERAND;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> CELL_VERIFICATION_OPERAND;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> GROUP_PROPERTY;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> OPTIONAL_PROPERTY_CHAIN;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> INPUT = procedure -> IfThenFactory.when(procedure.isCodeBeginning()).optional(() -> InputNode.INSTANCE);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> NUMBER = Tokens.NUMBER.nodeParser(DALNode.constNode(Token::getNumber));
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> INTEGER = Tokens.INTEGER.nodeParser(DALNode.constNode(Token::getInteger));
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SINGLE_QUOTED_STRING = Notations.SINGLE_QUOTED.with((NodeParser.Mandatory)Syntax.many(Compiler.charNode(SINGLE_QUOTED_ESCAPES)).and(Syntax.Rules.endWith(Notations.SINGLE_QUOTED.getLabel())).as(DALNode::constString));
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> DOUBLE_QUOTED_STRING = Notations.DOUBLE_QUOTED.with((NodeParser.Mandatory)Syntax.many(Compiler.charNode(DOUBLE_QUOTED_ESCAPES)).and(Syntax.Rules.endWith(Notations.DOUBLE_QUOTED.getLabel())).as(DALNode::constString));
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> CONST_TRUE = Notations.Keywords.TRUE.wordNode(DALNode::constTrue, Constants.PROPERTY_DELIMITER_STRING);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> CONST_FALSE = Notations.Keywords.FALSE.wordNode(DALNode::constFalse, Constants.PROPERTY_DELIMITER_STRING);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> CONST_NULL = Notations.Keywords.NULL.wordNode(DALNode::constNull, Constants.PROPERTY_DELIMITER_STRING);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> CONST_USER_DEFINED_LITERAL = this::compileUserDefinedLiteral;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> REGEX = Notations.OPEN_REGEX.with((NodeParser.Mandatory)Syntax.many(Compiler.charNode(REGEX_ESCAPES)).and(Syntax.Rules.endWith(Notations.CLOSE_REGEX.getLabel())).as(DALNode::regex));
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> WILDCARD = Notations.Operators.WILDCARD.node(WildcardNode::new);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> ROW_WILDCARD = Notations.Operators.ROW_WILDCARD.node(WildcardNode::new);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> CONST = (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.NUMBER, this.SINGLE_QUOTED_STRING, this.DOUBLE_QUOTED_STRING, this.CONST_TRUE, this.CONST_FALSE, this.CONST_NULL, this.CONST_USER_DEFINED_LITERAL});
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> ELEMENT_ELLIPSIS = Notations.Operators.ELEMENT_ELLIPSIS.node(token -> new ListEllipsisNode());
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SCHEMA = Tokens.SCHEMA.nodeParser(DALNode::schema);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> INTEGER_OR_STRING = (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.INTEGER, this.SINGLE_QUOTED_STRING, this.DOUBLE_QUOTED_STRING});
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> STRING_PROPERTY = procedure -> procedure.isEnableRelaxProperty() ? ((NodeParser)((Object)Syntax.single(Parser.oneOf((Parser[])new NodeParser[]{this.SINGLE_QUOTED_STRING, this.DOUBLE_QUOTED_STRING})).as(DALNode::stringSymbol))).parse(procedure) : Optional.empty();
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SYMBOL = procedure -> (procedure.isEnableRelaxProperty() ? Tokens.RELAX_SYMBOL : Tokens.SYMBOL).nodeParser(DALNode::symbolNode).parse((DALProcedure)procedure);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> DOT_SYMBOL = procedure -> (procedure.isEnableRelaxProperty() ? Tokens.RELAX_DOT_SYMBOL : Tokens.DOT_SYMBOL).nodeParser(DALNode::symbolNode).parse((DALProcedure)procedure);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> PROPERTY_PATTERN = this::propertyPattern;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> OPTIONAL_VERIFICATION_PROPERTY = procedure -> procedure.enableRelaxProperty(() -> procedure.enableSlashProperty(() -> this.OPTIONAL_PROPERTY_CHAIN.parse((DALProcedure)procedure)));
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> PROPERTY_CHAIN;
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> OPERAND;
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> EXPRESSION;
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SCHEMA_COMPOSE = (NodeParser.Mandatory)Notations.OPENING_BRACKET.with((NodeParser.Mandatory)Syntax.single((Parser.Mandatory)Syntax.many(this.SCHEMA.mandatory("Expect a schema")).and(Syntax.Rules.splitBy(Notations.SCHEMA_AND)).as(DALNode::elementSchemas)).and(Syntax.Rules.endWith(Notations.CLOSING_BRACKET)).as()).or((Parser.Mandatory)Syntax.many(this.SCHEMA.mandatory("Expect a schema")).and(Syntax.Rules.splitBy(Notations.SCHEMA_AND)).as(DALNode::schemas));
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> EXPRESSION_RELAX_STRING = Tokens.EXPRESSION_RELAX_STRING.nodeParser(DALNode::relaxString);
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> OBJECT_SCOPE_RELAX_STRING = Tokens.OBJECT_SCOPE_RELAX_STRING.nodeParser(DALNode::relaxString);
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> LIST_SCOPE_RELAX_STRING = Tokens.LIST_SCOPE_RELAX_STRING.nodeParser(DALNode::relaxString);
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> TABLE_CELL_RELAX_STRING = Tokens.TABLE_CELL_RELAX_STRING.nodeParser(DALNode::relaxString);
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> VERIFICATION_PROPERTY = procedure -> procedure.enableRelaxProperty(() -> procedure.enableSlashProperty(() -> (DALNode)this.PROPERTY_CHAIN.parse((DALProcedure)procedure)));
    public ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> ARITHMETIC_CLAUSE;
    public ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> VERIFICATION_CLAUSE;
    public ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SCHEMA_CLAUSE = IS.clause(this.SCHEMA_COMPOSE);
    public ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> WHICH_CLAUSE = ClauseParser.lazy(() -> WHICH.clause(this.EXPRESSION));
    public ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> LIST_MAPPING = Notations.LIST_MAPPING.clause((token, symbolNode) -> new ListMappingNode((DALNode)symbolNode));
    public ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> IMPLICIT_PROPERTY = PROPERTY_IMPLICIT.clause((NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.PROPERTY_PATTERN, ((NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.STRING_PROPERTY, this.SYMBOL})).concat(this.LIST_MAPPING)}));
    public ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> EXPLICIT_PROPERTY = (ClauseParser)Parser.oneOf((Parser[])new ClauseParser[]{PROPERTY_DOT.clause((NodeParser.Mandatory)this.PROPERTY_PATTERN.or(((NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.STRING_PROPERTY, this.DOT_SYMBOL})).concat(this.LIST_MAPPING).mandatory("Expect a symbol"))), PROPERTY_SLASH.clause((NodeParser.Mandatory)((NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.STRING_PROPERTY, this.DOT_SYMBOL})).concat(this.LIST_MAPPING).mandatory("Expect a symbol")), PROPERTY_IMPLICIT.clause(Notations.OPENING_BRACKET.with(((NodeParser.Mandatory)Syntax.single(this.INTEGER_OR_STRING.mandatory("Should given one property or array index in `[]`")).and(Syntax.Rules.endWith(Notations.CLOSING_BRACKET)).as(DALNode::bracketSymbolNode)).concat(this.LIST_MAPPING)))});
    private ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> ARITHMETIC_CLAUSE_CHAIN;
    private ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> VERIFICATION_CLAUSE_CHAIN;
    private ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> EXPLICIT_PROPERTY_CHAIN;
    private ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> WHICH_CLAUSE_CHAIN;
    private ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SCHEMA_CLAUSE_CHAIN;
    private ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> EXPRESSION_CLAUSE;
    private final NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SEQUENCE_AZ = Notations.SEQUENCE_AZ.node(SortNode::new);
    private final NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SEQUENCE_ZA = Notations.SEQUENCE_ZA.node(SortNode::new);
    private final NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SEQUENCE_AZ_2 = Notations.SEQUENCE_AZ_2.node(SortNode::new);
    private final NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SEQUENCE_ZA_2 = Notations.SEQUENCE_ZA_2.node(SortNode::new);
    private final NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> ROW_KEY = (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.INTEGER, this.OPTIONAL_VERIFICATION_PROPERTY});
    private final NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SEQUENCE = ((NodeParser)Parser.oneOf((Parser[])new NodeParser[]{(NodeParser)Syntax.many(this.SEQUENCE_AZ).and(Syntax.Rules.atLeast(1)).as(SortSequenceNode::new), (NodeParser)Syntax.many(this.SEQUENCE_AZ_2).and(Syntax.Rules.atLeast(1)).as(SortSequenceNode::new), (NodeParser)Syntax.many(this.SEQUENCE_ZA).and(Syntax.Rules.atLeast(1)).as(SortSequenceNode::new), (NodeParser)Syntax.many(this.SEQUENCE_ZA_2).and(Syntax.Rules.atLeast(1)).as(SortSequenceNode::new)})).or(procedure -> SortSequenceNode.noSequence());
    private final NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> ROW_PREFIX = procedure -> new RowPrefixNode(this.ROW_KEY.parse((DALProcedure)procedure), this.SCHEMA_CLAUSE.parse((DALProcedure)procedure), VERIFICATION_OPERATORS.parse((DALProcedure)procedure));
    private final NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> TABLE_HEADER = procedure -> new HeaderNode((SortSequenceNode)this.SEQUENCE.parse((DALProcedure)procedure), (DALNode)this.VERIFICATION_PROPERTY.concat(this.SCHEMA_CLAUSE).parse((DALProcedure)procedure), VERIFICATION_OPERATORS.parse((DALProcedure)procedure));
    private final ClauseParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> TABLE_BODY_CLAUSE = procedure -> head -> new TableNode((TableHead)head, (TableBody)((NodeParser.Mandatory)Syntax.many(this.ROW_PREFIX.combine((ClauseParser)Parser.oneOf((Parser[])new ClauseParser[]{(ClauseParser)Notations.COLUMN_SPLITTER.before(this.singleCellRow(this.ELEMENT_ELLIPSIS)), (ClauseParser)Notations.COLUMN_SPLITTER.before(this.singleCellRow(this.ROW_WILDCARD)), (ClauseParser)Notations.COLUMN_SPLITTER.before(this.tableRow((TableHead)head))}))).and(Syntax.Rules.endWithOptionalLine()).as(TableBody::new)).parse(procedure));

    private Optional<DALNode> propertyPattern(DALProcedure dalProcedure) {
        ClauseParser patternClause = Notation.notation("{}").clause((token, symbol) -> new PropertyPattern((DALNode)symbol));
        return ((NodeParser)Parser.oneOf((Parser[])new NodeParser[]{Notation.notation("{}").node(n -> new PropertyThis()), this.SYMBOL.and(patternClause)})).parse(dalProcedure);
    }

    private ClauseParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> shortVerificationClause(OperatorParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> operatorMandatory, NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> operand) {
        return procedure -> (Clause)this.SCHEMA_CLAUSE.concat(VERIFICATION_OPERATORS.clause(operand)).or(operatorMandatory.clause(operand)).parse((DALProcedure)procedure);
    }

    public Compiler() {
        this.PARENTHESES = NodeParser.lazy(() -> DALProcedure.enableCommaAnd(Notations.OPENING_PARENTHESES.with((NodeParser.Mandatory)Syntax.single(this.EXPRESSION).and(Syntax.Rules.endWith(Notations.CLOSING_PARENTHESES)).as(DALNode::parenthesesNode))));
        this.PROPERTY = NodeParser.lazy(() -> (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.GROUP_PROPERTY, ((ClauseParser)Parser.oneOf((Parser[])new ClauseParser[]{this.EXPLICIT_PROPERTY, this.IMPLICIT_PROPERTY})).defaultInputNode(InputNode.INSTANCE)}));
        this.OPTIONAL_PROPERTY_CHAIN = this.PROPERTY.recursive(this.EXPLICIT_PROPERTY);
        this.PROPERTY_CHAIN = (NodeParser.Mandatory)this.OPTIONAL_PROPERTY_CHAIN.mandatory("Expect a object property");
        this.OBJECT = NodeParser.lazy(() -> DALProcedure.disableCommaAnd(Notations.OPENING_BRACES.with((NodeParser.Mandatory)((NodeParser)Syntax.single(this.ELEMENT_ELLIPSIS).and(Syntax.Rules.endWith(Notations.CLOSING_BRACES)).as(ObjectScopeNode::new)).or((Parser.Mandatory)Syntax.many(this.VERIFICATION_PROPERTY.expression(this.shortVerificationClause((OperatorParser.Mandatory)VERIFICATION_OPERATORS.mandatory("Expect operator `:` or `=`"), this.SHORT_VERIFICATION_OPERAND.or(this.OBJECT_SCOPE_RELAX_STRING)))).and(Syntax.Rules.optionalSplitBy(Notations.COMMA)).and(Syntax.Rules.endWith(Notations.CLOSING_BRACES)).as(ObjectScopeNode::new)))));
        this.LIST = NodeParser.lazy(() -> DALProcedure.disableCommaAnd(Notations.OPENING_BRACKET.with((NodeParser.Mandatory)Syntax.many(this.ELEMENT_ELLIPSIS.ignoreInput().or(this.shortVerificationClause(VERIFICATION_OPERATORS.or(DEFAULT_VERIFICATION_OPERATOR), this.SHORT_VERIFICATION_OPERAND.or(this.LIST_SCOPE_RELAX_STRING)))).and(Syntax.Rules.optionalSplitBy(Notations.COMMA)).and(Syntax.Rules.endWith(Notations.CLOSING_BRACKET)).as(ListScopeNode::new))));
        this.TABLE = (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{Notations.TRANSPOSE_MARK.with(this.transposeTable().input(new EmptyTransposedTableHead())), ((NodeParser)Notations.COLUMN_SPLITTER.before(Notations.TRANSPOSE_MARK.before(Notations.COLUMN_SPLITTER.before((Parser.Mandatory)Compiler.tableLine(this.ROW_PREFIX).as(TransposedTableHead::new))))).withStartPosition().expression(this.transposeTable()), ((NodeParser)Notations.COLUMN_SPLITTER.before((Parser.Mandatory)Compiler.tableLine(this.TABLE_HEADER).as(TableHead::new))).withStartPosition().expression(this.TABLE_BODY_CLAUSE)});
        this.VERIFICATION_SPECIAL_OPERAND = (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.REGEX, this.OBJECT, this.LIST, this.WILDCARD, this.TABLE});
        this.OPERAND = (NodeParser.Mandatory)NodeParser.lazy(() -> (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{UNARY_OPERATORS.unary(this.OPERAND), this.CONST, this.PROPERTY, this.PARENTHESES, this.INPUT})).mandatory("Expect a value or expression");
        this.VERIFICATION_VALUE_OPERAND = (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{UNARY_OPERATORS.unary(this.OPERAND), this.CONST, this.EXPLICIT_PROPERTY.defaultInputNode(InputNode.INSTANCE), this.PARENTHESES});
        this.ARITHMETIC_CLAUSE = BINARY_ARITHMETIC_OPERATORS.clause(this.OPERAND);
        this.VERIFICATION_CLAUSE = VERIFICATION_OPERATORS.clause(((NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.VERIFICATION_SPECIAL_OPERAND, this.VERIFICATION_VALUE_OPERAND})).or(this.EXPRESSION_RELAX_STRING));
        this.ARITHMETIC_CLAUSE_CHAIN = ClauseParser.lazy(() -> this.ARITHMETIC_CLAUSE.concat(this.EXPRESSION_CLAUSE));
        this.VERIFICATION_CLAUSE_CHAIN = ClauseParser.lazy(() -> this.VERIFICATION_CLAUSE.concat(this.EXPRESSION_CLAUSE));
        this.EXPLICIT_PROPERTY_CHAIN = ClauseParser.lazy(() -> this.EXPLICIT_PROPERTY.concat(this.EXPRESSION_CLAUSE));
        this.WHICH_CLAUSE_CHAIN = ClauseParser.lazy(() -> this.WHICH_CLAUSE.concat(this.EXPRESSION_CLAUSE));
        this.SCHEMA_CLAUSE_CHAIN = ClauseParser.lazy(() -> this.SCHEMA_CLAUSE.concat((ClauseParser)Parser.oneOf((Parser[])new ClauseParser[]{this.VERIFICATION_CLAUSE_CHAIN, this.WHICH_CLAUSE_CHAIN, this.SCHEMA_CLAUSE_CHAIN})));
        this.EXPRESSION_CLAUSE = (ClauseParser)Parser.oneOf((Parser[])new ClauseParser[]{this.ARITHMETIC_CLAUSE_CHAIN, this.VERIFICATION_CLAUSE_CHAIN, this.EXPLICIT_PROPERTY_CHAIN, this.WHICH_CLAUSE_CHAIN, this.SCHEMA_CLAUSE_CHAIN});
        this.EXPRESSION = this.OPERAND.concat(this.EXPRESSION_CLAUSE);
        this.SHORT_VERIFICATION_OPERAND = (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.VERIFICATION_SPECIAL_OPERAND, this.VERIFICATION_VALUE_OPERAND.recursive((ClauseParser)Parser.oneOf((Parser[])new ClauseParser[]{this.ARITHMETIC_CLAUSE}))});
        this.CELL_VERIFICATION_OPERAND = (NodeParser)Syntax.single(Parser.oneOf((Parser[])new NodeParser[]{(NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.REGEX, this.OBJECT, this.LIST, this.WILDCARD}), this.VERIFICATION_VALUE_OPERAND.recursive((ClauseParser)Parser.oneOf((Parser[])new ClauseParser[]{this.ARITHMETIC_CLAUSE}))})).and(Syntax.Rules.enabledBefore(Notations.COLUMN_SPLITTER)).as();
        this.GROUP_PROPERTY = DALProcedure.disableCommaAnd(Notations.OPENING_GROUP.with((NodeParser.Mandatory)Syntax.many(this.PROPERTY_CHAIN).and(Syntax.Rules.optionalSplitBy(Notations.COMMA)).and(Syntax.Rules.endWith(Notations.CLOSING_GROUP)).as(GroupNode::new)));
    }

    public List<DALNode> compile(final SourceCode sourceCode, final RuntimeContextBuilder.DALRuntimeContext DALRuntimeContext2) {
        return new ArrayList<DALNode>(){
            {
                DALProcedure dalParser = new DALProcedure(sourceCode, DALRuntimeContext2, DALExpression::new);
                this.add(Compiler.this.EXPRESSION.parse(dalParser));
                if (sourceCode.isBeginning() && sourceCode.hasCode()) {
                    throw sourceCode.syntaxError("Unexpected token", 0);
                }
                while (sourceCode.hasCode()) {
                    this.add(Compiler.this.EXPRESSION.parse(dalParser));
                }
            }
        };
    }

    private static NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> charNode(EscapeChars escapeChars) {
        return procedure -> new ConstNode(Character.valueOf(procedure.getSourceCode().popChar(escapeChars)));
    }

    public List<Object> toChainNodes(String sourceCode) {
        return ((DALNode)this.PROPERTY_CHAIN.parse(new DALProcedure(SourceCode.createSourceCode(sourceCode, Notations.LINE_COMMENTS), null, DALExpression::new))).propertyChain();
    }

    private ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> singleCellRow(NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> element_ellipsis) {
        return ((NodeParser)Syntax.single((Parser)Syntax.single(element_ellipsis).and(Syntax.Rules.endWith(Notations.COLUMN_SPLITTER)).as()).and(Syntax.Rules.endWithLine()).as()).clauseParser(RowNode::new);
    }

    private NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> tableCell(DALNode rowPrefix, TableHead head) {
        return procedure -> procedure.positionOf(cellPosition -> (DALNode)((DALNode)this.shortVerificationClause(((OperatorParser)Parser.oneOf((Parser[])new OperatorParser[]{VERIFICATION_OPERATORS, head.getHeader((DALProcedure)procedure).headerOperator(), ((RowPrefixNode)rowPrefix).rowOperator()})).or(DEFAULT_VERIFICATION_OPERATOR), this.CELL_VERIFICATION_OPERAND.or(this.TABLE_CELL_RELAX_STRING)).input(head.getHeader((DALProcedure)procedure).getProperty()).parse((DALProcedure)procedure)).setPositionBegin((int)cellPosition));
    }

    private ClauseParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> tableRow(TableHead tableHead) {
        return NodeParser.Mandatory.clause(rowPrefix -> Compiler.tableLine(this.tableCell((DALNode)rowPrefix, tableHead)).as(cells -> new RowNode((DALNode)rowPrefix, (List<DALNode>)cells)));
    }

    private NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> transposeTableCell(DALNode head, DALNode transposedTableHead) {
        return procedure -> procedure.positionOf(cellPosition -> (DALNode)((DALNode)((NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.ELEMENT_ELLIPSIS, this.ROW_WILDCARD})).or(this.shortVerificationClause(((OperatorParser)Parser.oneOf((Parser[])new OperatorParser[]{VERIFICATION_OPERATORS, ((HeaderNode)head).headerOperator(), ((TransposedTableHead)transposedTableHead).getPrefix(procedure.getIndex()).rowOperator()})).or(DEFAULT_VERIFICATION_OPERATOR), this.CELL_VERIFICATION_OPERAND.or(this.TABLE_CELL_RELAX_STRING)).input(((HeaderNode)head).getProperty())).parse((DALProcedure)procedure)).setPositionBegin((int)cellPosition));
    }

    private ClauseParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> transposeTable() {
        return procedure -> prefixHead -> new TransposedTableNode((DALNode)prefixHead, (DALNode)((NodeParser.Mandatory)((NodeParser)Syntax.many(((NodeParser)Notations.COLUMN_SPLITTER.before((Parser.Mandatory)Syntax.single(this.TABLE_HEADER).and(Syntax.Rules.endWith(Notations.COLUMN_SPLITTER)).as())).withStartPosition().expression(NodeParser.Mandatory.clause(header -> Compiler.tableLine(this.transposeTableCell((DALNode)header, (DALNode)prefixHead)).as(cells -> new TransposedRowNode((DALNode)header, (List<DALNode>)cells))))).and(Syntax.Rules.atLeast(1)).and(Syntax.Rules.endWithOptionalLine()).as(TransposedTableBody::new)).mandatory("Expecting a table")).parse(procedure));
    }

    private static Syntax<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure, NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>, NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>, DALNode, NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>, List<DALNode>> tableLine(NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> mandatory) {
        return Syntax.many(mandatory).and(Syntax.Rules.mandatorySplitBy(Notations.COLUMN_SPLITTER)).and(Syntax.endOfRow(Notations.COLUMN_SPLITTER));
    }

    private Optional<DALNode> compileUserDefinedLiteral(DALProcedure dalProcedure) {
        return dalProcedure.getSourceCode().tryFetch(() -> Tokens.SYMBOL.scan(dalProcedure.getSourceCode()).flatMap(token -> ((RuntimeContextBuilder.DALRuntimeContext)dalProcedure.getRuntimeContext()).takeUserDefinedLiteral(token.getContent()).map(result -> (DALNode)new ConstNode(result.getValue()).setPositionBegin(token.getPosition()))));
    }
}

