/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.dal.ast.DALExpression;
import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.DALOperator;
import com.github.leeonky.dal.compiler.Constants;
import com.github.leeonky.dal.compiler.DALProcedure;
import com.github.leeonky.dal.compiler.Notations;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.FunctionUtil;
import com.github.leeonky.interpreter.SourceCode;
import com.github.leeonky.interpreter.Token;
import com.github.leeonky.interpreter.TokenScanner;
import java.util.Collections;
import java.util.List;

public class Tokens {
    public static final TokenScanner<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> NUMBER = SourceCode.tokenScanner(Constants.DIGITAL::contains, Collections.emptySet(), false, Tokens::notNumber, Token::isNumber);
    public static final TokenScanner<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> INTEGER = SourceCode.tokenScanner(Constants.DIGITAL_OR_MINUS::contains, Collections.emptySet(), false, Tokens::notNumber, Token::isNumber);
    public static final TokenScanner<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SYMBOL = SourceCode.tokenScanner(FunctionUtil.not(Constants.PROPERTY_DELIMITER::contains), Notations.Keywords.ALL_STRING, false, Constants.PROPERTY_DELIMITER, FunctionUtil.not(Token::isNumber));
    public static final TokenScanner<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> DOT_SYMBOL = SourceCode.tokenScanner(FunctionUtil.not(Constants.PROPERTY_DELIMITER::contains), Collections.emptySet(), false, Constants.PROPERTY_DELIMITER, FunctionUtil.not(Token::isNumber));
    public static final TokenScanner<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> RELAX_SYMBOL = SourceCode.tokenScanner(FunctionUtil.not(Constants.RELAX_PROPERTY_DELIMITER::contains), Notations.Keywords.ALL_STRING, false, Constants.RELAX_PROPERTY_DELIMITER, FunctionUtil.not(Token::isNumber));
    public static final TokenScanner<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> RELAX_DOT_SYMBOL = SourceCode.tokenScanner(FunctionUtil.not(Constants.RELAX_PROPERTY_DELIMITER::contains), Collections.emptySet(), false, Constants.RELAX_PROPERTY_DELIMITER, FunctionUtil.not(Token::isNumber));
    public static final TokenScanner<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SCHEMA = SourceCode.tokenScanner(FunctionUtil.not(Constants.DELIMITER::contains), Notations.Keywords.ALL_STRING, false, Constants.DELIMITER, FunctionUtil.not(Token::isNumber));
    public static final TokenScanner.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> EXPRESSION_RELAX_STRING = Tokens.relaxString(Constants.EXPRESSION_RELAX_STRING_TAIL);
    public static final TokenScanner.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> OBJECT_SCOPE_RELAX_STRING = Tokens.relaxString(Constants.OBJECT_SCOPE_RELAX_STRING_TAIL);
    public static final TokenScanner.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> LIST_SCOPE_RELAX_STRING = Tokens.relaxString(Constants.LIST_SCOPE_RELAX_STRING_TAIL);
    public static final TokenScanner.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> TABLE_CELL_RELAX_STRING = Tokens.relaxString(Constants.TABLE_CELL_RELAX_STRING_TAIL);

    private static TokenScanner.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> relaxString(List<String> expressionRelaxStringTail) {
        return SourceCode.tokenScanner(false, (code, position, size) -> expressionRelaxStringTail.stream().anyMatch(tail -> code.startsWith((String)tail, (int)position)));
    }

    private static boolean notNumber(String code, int position, int size) {
        if (size == 0) {
            return false;
        }
        return Tokens.notSymbolAfterPower(code, position) || Tokens.notNumberPoint(code, position);
    }

    private static boolean notNumberPoint(String code, int position) {
        return code.charAt(position) == '.' && (position == code.length() - 1 || !Constants.DIGITAL.contains(Character.valueOf(code.charAt(position + 1))));
    }

    private static boolean notSymbolAfterPower(String code, int position) {
        char current = code.charAt(position);
        char lastChar = code.charAt(position - 1);
        return Constants.DELIMITER.contains(Character.valueOf(current)) && Tokens.notSymbolAfterPower(Character.valueOf(lastChar), Character.valueOf(current)) || lastChar == '.' && !Constants.DIGITAL.contains(Character.valueOf(current));
    }

    private static boolean notSymbolAfterPower(Character lastChar, Character nextChar) {
        return lastChar.charValue() != 'e' && lastChar.charValue() != 'E' || nextChar.charValue() != '-' && nextChar.charValue() != '+';
    }
}

