/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.format;

import com.github.leeonky.dal.runtime.IllegalTypeException;

public interface Formatter<T, R> {
    public R convert(T var1);

    public boolean isValidType(Object var1);

    default public boolean isValid(T value) {
        try {
            return this.isValidValue(this.transform(value));
        }
        catch (IllegalTypeException ignore) {
            return false;
        }
    }

    default public boolean isValidValue(R value) {
        return true;
    }

    default public String getFormatterName() {
        return this.getClass().getSimpleName().replaceFirst("^Formatter", "");
    }

    default public R transform(T o) {
        if (this.isValidType(o)) {
            return this.convert(o);
        }
        throw new IllegalTypeException();
    }
}

