/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.TableNode;
import com.github.leeonky.dal.ast.TransposedTableNode;
import com.github.leeonky.dal.runtime.DalException;
import com.github.leeonky.interpreter.FunctionUtil;
import com.github.leeonky.interpreter.InterpreterException;

public class RowAssertionFailure
extends RuntimeException {
    protected final int row;
    protected final DalException dalException;

    public RowAssertionFailure(int row, DalException dalException) {
        this.row = row;
        this.dalException = dalException;
    }

    public DalException linePositionException(TableNode tableNode) {
        this.dalException.setType(InterpreterException.Position.Type.LINE);
        return this.dalException;
    }

    public DalException columnPositionException(TransposedTableNode transposedTableNode) {
        this.dalException.clearPosition();
        return transposedTableNode.transpose().getDataRowByDataIndex(this.row).getCells().stream().reduce(this.dalException, this::markPosition, FunctionUtil.notAllowParallelReduce());
    }

    protected DalException markPosition(DalException e, DALNode cell) {
        return (DalException)e.multiPosition(cell.getPositionBegin(), InterpreterException.Position.Type.CHAR);
    }
}

