/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.interpreter;

import com.github.leeonky.interpreter.ClauseParser;
import com.github.leeonky.interpreter.Expression;
import com.github.leeonky.interpreter.Node;
import com.github.leeonky.interpreter.NodeParser;
import com.github.leeonky.interpreter.Operator;
import com.github.leeonky.interpreter.OperatorParser;
import com.github.leeonky.interpreter.Parser;
import com.github.leeonky.interpreter.Procedure;
import com.github.leeonky.interpreter.RuntimeContext;
import com.github.leeonky.interpreter.Token;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Notation {
    private final String label;

    private Notation(String label) {
        this.label = label;
    }

    public static Notation notation(String label) {
        return new Notation(label);
    }

    public String getLabel() {
        return this.label;
    }

    public int length() {
        return this.label.length();
    }

    private <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>> Optional<Token> getToken(P procedure, Predicate<P> predicate) {
        return procedure.getSourceCode().popWord(this, () -> predicate.test(procedure));
    }

    private <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>> Optional<Token> getToken(P procedure) {
        return this.getToken(procedure, p -> true);
    }

    public <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>> NodeParser<C, N, E, O, P> node(Function<String, N> factory) {
        return procedure -> this.getToken(procedure).map(token -> ((Node)factory.apply(token.getContent())).setPositionBegin(token.getPosition()));
    }

    public <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>> NodeParser<C, N, E, O, P> wordNode(Function<String, N> factory, Set<String> Delimiter) {
        return procedure -> procedure.getSourceCode().tryFetch(() -> this.getToken(procedure).map(token -> this.notAWord(Delimiter, procedure) ? null : (Node)((Node)factory.apply(token.getContent())).setPositionBegin(token.getPosition())));
    }

    private <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>> boolean notAWord(Set<String> Delimiter, P procedure) {
        return procedure.getSourceCode().hasCode() && Delimiter.stream().noneMatch(s -> procedure.getSourceCode().startsWith((String)s));
    }

    public <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>> OperatorParser<C, N, E, O, P> operator(Supplier<O> factory, Predicate<P> predicate) {
        return procedure -> this.getToken(procedure, predicate).map(arg_0 -> Notation.lambda$null$8((Supplier)factory, arg_0));
    }

    public <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>> OperatorParser<C, N, E, O, P> operator(Supplier<O> factory) {
        return this.operator(factory, procedure -> true);
    }

    public <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>> OperatorParser<C, N, E, O, P> keywordOperator(Supplier<O> factory, Set<String> Delimiter) {
        return procedure -> procedure.getSourceCode().tryFetch(() -> this.lambda$null$13((Supplier)factory, procedure, Delimiter));
    }

    public <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>> NodeParser<C, N, E, O, P> with(NodeParser.Mandatory<C, N, E, O, P> mandatory) {
        return procedure -> this.getToken(procedure).map(t -> ((Node)mandatory.parse(procedure)).setPositionBegin(t.getPosition()));
    }

    public <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T> PA before(PA parser) {
        return parser.castParser(procedure -> procedure.getSourceCode().tryFetch(() -> this.getToken(procedure).flatMap(t -> parser.parse(procedure))));
    }

    public <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T> PA before(MA ma) {
        return ma.castParser(procedure -> this.getToken(procedure).map(t -> ma.parse(procedure)));
    }

    public <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>> ClauseParser<C, N, E, O, P> clause(BiFunction<Token, N, N> nodeFactory) {
        return procedure -> this.getToken(procedure).map(token -> input -> ((Node)nodeFactory.apply((Token)token, (Object)input)).setPositionBegin(token.getPosition()));
    }

    private /* synthetic */ Optional lambda$null$13(Supplier factory, Procedure procedure, Set Delimiter) {
        return this.operator(factory, p -> true).parse(procedure).map(operator -> this.notAWord(Delimiter, procedure) ? null : operator);
    }

    private static /* synthetic */ Operator lambda$null$8(Supplier factory, Token token) {
        return ((Operator)factory.get()).setPosition(token.getPosition());
    }
}

