/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.interpreter;

import com.github.leeonky.interpreter.Expression;
import com.github.leeonky.interpreter.ExpressionFactory;
import com.github.leeonky.interpreter.Node;
import com.github.leeonky.interpreter.Operator;
import com.github.leeonky.interpreter.RuntimeContext;
import com.github.leeonky.interpreter.SourceCode;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;

public class Procedure<C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>> {
    private final SourceCode sourceCode;
    private final C runtimeContext;
    private final LinkedList<O> operators = new LinkedList();
    private final ExpressionFactory<C, N, E, O> expressionFactory;
    private final LinkedList<AtomicInteger> columns = new LinkedList();

    public Procedure(SourceCode sourceCode, C runtimeContext, ExpressionFactory<C, N, E, O> expressionFactory) {
        this.sourceCode = sourceCode;
        this.runtimeContext = runtimeContext;
        this.expressionFactory = expressionFactory;
    }

    public SourceCode getSourceCode() {
        return this.sourceCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T underOperator(O operator, Supplier<T> action) {
        this.operators.push(operator);
        try {
            T t = action.get();
            return t;
        }
        finally {
            this.operators.pop();
        }
    }

    public <T> T positionOf(Function<Integer, T> action) {
        return action.apply(this.getSourceCode().nextPosition());
    }

    public <T> T withIndex(Supplier<T> action) {
        this.columns.push(new AtomicInteger());
        try {
            T t = action.get();
            return t;
        }
        finally {
            this.columns.poll();
        }
    }

    public int getIndex() {
        return this.columns.getFirst().get();
    }

    public void incrementIndex() {
        this.columns.getFirst().incrementAndGet();
    }

    public N createExpression(N node1, O operator, N node2) {
        return this.expressionFactory.create(node1, operator, node2).applyPrecedence(this.expressionFactory);
    }

    public C getRuntimeContext() {
        return this.runtimeContext;
    }

    public Optional<O> currentOperator() {
        return this.operators.stream().findFirst();
    }
}

