/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.interpreter;

import com.github.leeonky.interpreter.Expression;
import com.github.leeonky.interpreter.IfThenFactory;
import com.github.leeonky.interpreter.Node;
import com.github.leeonky.interpreter.NodeParser;
import com.github.leeonky.interpreter.Notation;
import com.github.leeonky.interpreter.Operator;
import com.github.leeonky.interpreter.Parser;
import com.github.leeonky.interpreter.Procedure;
import com.github.leeonky.interpreter.RuntimeContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class Syntax<C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T, R, A> {
    protected final BiFunction<P, Syntax<C, N, E, O, P, PA, MA, ?, ?, A>, A> parser;

    protected Syntax(BiFunction<P, Syntax<C, N, E, O, P, PA, MA, ?, ?, A>, A> parser) {
        this.parser = parser;
    }

    protected abstract boolean isClose(P var1);

    protected abstract void close(P var1);

    protected abstract boolean isSplitter(P var1);

    protected R parse(Syntax<C, N, E, O, P, PA, MA, T, R, A> syntax, Function<A, N> factory) {
        return (R)((NodeParser.Mandatory)procedure -> (Node)factory.apply(this.parser.apply(procedure, syntax)));
    }

    public <NR, NA> Syntax<C, N, E, O, P, PA, MA, T, NR, NA> and(Function<Syntax<C, N, E, O, P, PA, MA, T, R, A>, Syntax<C, N, E, O, P, PA, MA, T, NR, NA>> rule) {
        return rule.apply(this);
    }

    public R as(Function<A, N> factory) {
        return this.parse(this, factory);
    }

    public R as() {
        return this.parse(this, a -> (Node)a);
    }

    public static <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T> Syntax<C, N, E, O, P, PA, MA, T, NodeParser<C, N, E, O, P>, T> single(PA parser) {
        return new DefaultSyntax<C, N, E, O, P, PA, MA, T, NodeParser<C, N, E, O, P>, T>((procedure, syntax) -> {
            Optional optional = parser.parse(procedure);
            if (optional.isPresent()) {
                syntax.isClose(procedure);
                syntax.close(procedure);
            }
            return optional.orElse(null);
        }){

            @Override
            protected NodeParser<C, N, E, O, P> parse(Syntax<C, N, E, O, P, PA, MA, T, NodeParser<C, N, E, O, P>, T> syntax, Function<T, N> factory) {
                return procedure -> Optional.ofNullable(this.parser.apply(procedure, syntax)).map(factory);
            }
        };
    }

    public static <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T> Syntax<C, N, E, O, P, PA, MA, T, NodeParser.Mandatory<C, N, E, O, P>, T> single(MA parser) {
        return new DefaultSyntax<C, N, E, O, P, PA, MA, T, NodeParser.Mandatory<C, N, E, O, P>, T>((procedure, syntax) -> {
            Object t = parser.parse(procedure);
            syntax.isClose(procedure);
            syntax.close(procedure);
            return t;
        }){

            @Override
            protected NodeParser.Mandatory<C, N, E, O, P> parse(Syntax<C, N, E, O, P, PA, MA, T, NodeParser.Mandatory<C, N, E, O, P>, T> syntax, Function<T, N> factory) {
                return procedure -> (Node)factory.apply(this.parser.apply(procedure, syntax));
            }
        };
    }

    public static <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T> Syntax<C, N, E, O, P, PA, MA, T, NodeParser.Mandatory<C, N, E, O, P>, List<T>> many(MA mandatory) {
        return new DefaultSyntax((procedure, syntax) -> procedure.withIndex(() -> new ArrayList<T>((Syntax)syntax, (Procedure)procedure, mandatory){
            final /* synthetic */ Syntax val$syntax;
            final /* synthetic */ Procedure val$procedure;
            final /* synthetic */ Parser.Mandatory val$mandatory;
            {
                this.val$syntax = syntax;
                this.val$procedure = procedure;
                this.val$mandatory = mandatory;
                while (!this.val$syntax.isClose(this.val$procedure)) {
                    this.add(this.val$mandatory.parse(this.val$procedure));
                    this.val$procedure.incrementIndex();
                    if (this.val$syntax.isSplitter(this.val$procedure)) continue;
                }
                this.val$syntax.close(this.val$procedure);
            }
        }));
    }

    public static <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T> Syntax<C, N, E, O, P, PA, MA, T, NodeParser.Mandatory<C, N, E, O, P>, List<T>> many(PA parser) {
        return new DefaultSyntax((procedure, syntax) -> procedure.withIndex(() -> new ArrayList<T>((Syntax)syntax, (Procedure)procedure, parser){
            final /* synthetic */ Syntax val$syntax;
            final /* synthetic */ Procedure val$procedure;
            final /* synthetic */ Parser val$parser;
            {
                Optional optional;
                this.val$syntax = syntax;
                this.val$procedure = procedure;
                this.val$parser = parser;
                while (!this.val$syntax.isClose(this.val$procedure) && (optional = this.val$parser.parse(this.val$procedure)).isPresent()) {
                    this.add(optional.get());
                    this.val$procedure.incrementIndex();
                    if (this.val$syntax.isSplitter(this.val$procedure)) continue;
                    break;
                }
                this.val$syntax.close(this.val$procedure);
            }
        }));
    }

    public static <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T, R, A> Function<Syntax<C, N, E, O, P, PA, MA, T, R, A>, Syntax<C, N, E, O, P, PA, MA, T, R, A>> endOfRow(final Notation splitter) {
        return syntax -> new CompositeSyntax<C, N, E, O, P, PA, MA, T, R, A>((Syntax)syntax){
            private boolean isClose;
            {
                super(syntax);
                this.isClose = false;
            }

            @Override
            public boolean isClose(P procedure) {
                boolean bl = this.isClose = ((Procedure)procedure).getSourceCode().isEndOfLine() || !((Procedure)procedure).getSourceCode().hasCode();
                if (this.isClose) {
                    if (((Procedure)procedure).getSourceCode().hasCode()) {
                        ((Procedure)procedure).getSourceCode().popChar(Collections.emptyMap());
                    }
                } else {
                    String code = ((Procedure)procedure).getSourceCode().codeBefore(splitter);
                    this.isClose = code.contains("\r") || code.contains("\n");
                }
                return this.isClose;
            }

            @Override
            public void close(P procedure) {
                if (!this.isClose) {
                    throw ((Procedure)procedure).getSourceCode().syntaxError("unexpected token", 0);
                }
            }
        };
    }

    public static class Rules {
        public static <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T, R, A> Function<Syntax<C, N, E, O, P, PA, MA, T, R, A>, Syntax<C, N, E, O, P, PA, MA, T, R, A>> endWith(final Notation notation) {
            return syntax -> new CompositeSyntax<C, N, E, O, P, PA, MA, T, R, A>((Syntax)syntax){

                @Override
                public void close(P procedure) {
                    if (!((Procedure)procedure).getSourceCode().popWord(notation).isPresent()) {
                        throw ((Procedure)procedure).getSourceCode().syntaxError(String.format("Should end with `%s`", notation.getLabel()), 0);
                    }
                }

                @Override
                public boolean isClose(P procedure) {
                    return ((Procedure)procedure).getSourceCode().startsWith(notation) || !((Procedure)procedure).getSourceCode().hasCode();
                }
            };
        }

        public static <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T, R, A> Function<Syntax<C, N, E, O, P, PA, MA, T, R, A>, Syntax<C, N, E, O, P, PA, MA, T, R, A>> endWith(final String closing) {
            return syntax -> new CompositeSyntax<C, N, E, O, P, PA, MA, T, R, A>(syntax.and(Rules.endWith(Notation.notation(closing)))){

                @Override
                public boolean isClose(P procedure) {
                    return !((Procedure)procedure).getSourceCode().hasCode() || ((Procedure)procedure).getSourceCode().startsWith(closing);
                }
            };
        }

        public static <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T, R, A> Function<Syntax<C, N, E, O, P, PA, MA, T, R, A>, Syntax<C, N, E, O, P, PA, MA, T, R, A>> endWithLine() {
            return syntax -> new CompositeSyntax<C, N, E, O, P, PA, MA, T, R, A>((Syntax)syntax){
                private boolean isClose = false;

                @Override
                public boolean isClose(P procedure) {
                    this.isClose = ((Procedure)procedure).getSourceCode().isEndOfLine();
                    if (this.isClose && ((Procedure)procedure).getSourceCode().hasCode()) {
                        ((Procedure)procedure).getSourceCode().popChar(Collections.emptyMap());
                    }
                    return this.isClose;
                }

                @Override
                public void close(P procedure) {
                    if (!this.isClose) {
                        throw ((Procedure)procedure).getSourceCode().syntaxError("unexpected token", 0);
                    }
                }
            };
        }

        public static <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T, R, A> Function<Syntax<C, N, E, O, P, PA, MA, T, R, A>, Syntax<C, N, E, O, P, PA, MA, T, R, A>> splitBy(final Notation notation) {
            return syntax -> new CompositeSyntax<C, N, E, O, P, PA, MA, T, R, A>((Syntax)syntax){

                @Override
                public boolean isSplitter(P procedure) {
                    return ((Procedure)procedure).getSourceCode().popWord(notation).isPresent();
                }
            };
        }

        public static <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T, R, A> Function<Syntax<C, N, E, O, P, PA, MA, T, R, A>, Syntax<C, N, E, O, P, PA, MA, T, R, A>> endWithOptionalLine() {
            return syntax -> new CompositeSyntax<C, N, E, O, P, PA, MA, T, R, A>(syntax.and(Rules.endWithLine())){

                @Override
                public void close(P procedure) {
                }
            };
        }

        public static <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T, R, A> Function<Syntax<C, N, E, O, P, PA, MA, T, R, A>, Syntax<C, N, E, O, P, PA, MA, T, R, A>> optionalSplitBy(final Notation splitter) {
            return syntax -> new CompositeSyntax<C, N, E, O, P, PA, MA, T, R, A>((Syntax)syntax){

                @Override
                public boolean isSplitter(P procedure) {
                    ((Procedure)procedure).getSourceCode().popWord(splitter);
                    return true;
                }
            };
        }

        public static <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T, R, A> Function<Syntax<C, N, E, O, P, PA, MA, T, R, A>, Syntax<C, N, E, O, P, PA, MA, T, R, A>> mandatorySplitBy(final Notation splitter) {
            return syntax -> new CompositeSyntax<C, N, E, O, P, PA, MA, T, R, A>((Syntax)syntax){

                @Override
                public boolean isSplitter(P procedure) {
                    if (((Procedure)procedure).getSourceCode().popWord(splitter).isPresent()) {
                        return true;
                    }
                    throw ((Procedure)procedure).getSourceCode().syntaxError(String.format("Should end with `%s`", splitter.getLabel()), 0);
                }
            };
        }

        public static <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T, R, A> Function<Syntax<C, N, E, O, P, PA, MA, T, R, A>, Syntax<C, N, E, O, P, PA, MA, T, NodeParser<C, N, E, O, P>, List<T>>> atLeast(final int size) {
            return syntax -> new CompositeSyntax<C, N, E, O, P, PA, MA, T, NodeParser<C, N, E, O, P>, List<T>>((Syntax)syntax){

                @Override
                protected NodeParser<C, N, E, O, P> parse(Syntax<C, N, E, O, P, PA, MA, T, NodeParser<C, N, E, O, P>, List<T>> syntax, Function<List<T>, N> factory) {
                    return procedure -> procedure.getSourceCode().tryFetch(() -> {
                        List list = (List)this.parser.apply(procedure, syntax);
                        return IfThenFactory.when(list.size() >= size).optional(() -> (Node)factory.apply(list));
                    });
                }
            };
        }

        public static <C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T, A> Function<Syntax<C, N, E, O, P, PA, MA, T, NodeParser<C, N, E, O, P>, A>, Syntax<C, N, E, O, P, PA, MA, T, NodeParser<C, N, E, O, P>, A>> enabledBefore(final Notation notation) {
            return syntax -> new CompositeSyntax<C, N, E, O, P, PA, MA, T, NodeParser<C, N, E, O, P>, A>((Syntax)syntax){

                @Override
                protected NodeParser<C, N, E, O, P> parse(Syntax<C, N, E, O, P, PA, MA, T, NodeParser<C, N, E, O, P>, A> syntax, Function<A, N> factory) {
                    NodeParser nodeParser = super.parse(syntax, factory);
                    return procedure -> procedure.getSourceCode().tryFetch(() -> nodeParser.parse(procedure).map(node -> procedure.getSourceCode().startsWith(notation) ? node : null));
                }
            };
        }
    }

    public static class CompositeSyntax<C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T, R, A>
    extends Syntax<C, N, E, O, P, PA, MA, T, R, A> {
        private final Syntax<C, N, E, O, P, PA, MA, T, R, A> syntax;

        public CompositeSyntax(Syntax<C, N, E, O, P, PA, MA, T, R, A> syntax) {
            super(syntax.parser);
            this.syntax = syntax;
        }

        @Override
        protected boolean isClose(P procedure) {
            return this.syntax.isClose(procedure);
        }

        @Override
        protected void close(P procedure) {
            this.syntax.close(procedure);
        }

        @Override
        protected boolean isSplitter(P procedure) {
            return this.syntax.isSplitter(procedure);
        }

        @Override
        protected R parse(Syntax<C, N, E, O, P, PA, MA, T, R, A> syntax, Function<A, N> factory) {
            return this.syntax.parse(syntax, factory);
        }
    }

    public static class DefaultSyntax<C extends RuntimeContext<C>, N extends Node<C, N>, E extends Expression<C, N, E, O>, O extends Operator<C, N, O>, P extends Procedure<C, N, E, O, P>, PA extends Parser<C, N, E, O, P, PA, MA, T>, MA extends Parser.Mandatory<C, N, E, O, P, PA, MA, T>, T, R, A>
    extends Syntax<C, N, E, O, P, PA, MA, T, R, A> {
        public DefaultSyntax(BiFunction<P, Syntax<C, N, E, O, P, PA, MA, ?, ?, A>, A> parser) {
            super(parser);
        }

        @Override
        protected boolean isClose(P procedure) {
            return false;
        }

        @Override
        protected void close(P procedure) {
        }

        @Override
        protected boolean isSplitter(P procedure) {
            return true;
        }
    }
}

