/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.ExcuteableNode;
import com.github.leeonky.dal.ast.SymbolNode;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ElementAccessException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.util.BeanClass;

public class ListMappingNode
extends DALNode
implements ExcuteableNode {
    private final SymbolNode symbolNode;

    public ListMappingNode(DALNode symbolNode) {
        this.symbolNode = (SymbolNode)symbolNode;
        this.setPositionBegin(symbolNode.getPositionBegin());
    }

    @Override
    public String inspect() {
        return this.symbolNode.inspect() + "[]";
    }

    @Override
    public Data getPropertyValue(Data data, RuntimeContextBuilder.DALRuntimeContext context) {
        try {
            if (!data.isList()) {
                throw new RuntimeException(String.format("The instance of '%s' is not a list", BeanClass.createFrom((Object)data.getInstance()).getName()), this.getPositionBegin());
            }
            return data.mapList(this.symbolNode.getRootSymbolName());
        }
        catch (ElementAccessException e) {
            throw e.toDalError(this.symbolNode.getPositionBegin());
        }
    }
}

