/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.AssertionFailure;
import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.SchemaNode;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.IllegalTypeException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class SchemaComposeNode
extends DALNode {
    private final List<SchemaNode> schemas;
    private final boolean isList;
    private final ObjectRef objectRef = new ObjectRef();

    public SchemaComposeNode(List<SchemaNode> schemas, boolean isList) {
        this.schemas = schemas;
        this.isList = isList;
    }

    @Override
    public String inspect() {
        Collector<CharSequence, ?, String> joining = this.isList ? Collectors.joining(" / ", "[", "]") : Collectors.joining(" / ");
        return this.schemas.stream().map(SchemaNode::inspect).collect(joining);
    }

    public Data verify(DALNode input, RuntimeContextBuilder.DALRuntimeContext context) {
        try {
            this.schemas.forEach(schemaNode -> this.verifyAndConvertAsSchemaType(context, (SchemaNode)schemaNode, this.objectRef, input));
            return context.wrap(this.objectRef.instance, this.schemas.get(0).inspect(), this.isList);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e.getMessage(), this.getPositionBegin());
        }
    }

    private void verifyAndConvertAsSchemaType(RuntimeContextBuilder.DALRuntimeContext context, SchemaNode schemaNode, ObjectRef objectRef, DALNode input) {
        Data inputData = input.evaluateData(context);
        if (this.isList) {
            if (!inputData.isList()) {
                throw new SyntaxException("Expecting a list but was " + inputData.inspect(), input.getPositionBegin());
            }
            AtomicInteger index = new AtomicInteger(0);
            objectRef.instance = inputData.getListObjects().stream().map(element -> this.convertViaSchema(context, schemaNode, (Data)element, String.format("%s[%d]", input.inspect(), index.getAndIncrement()))).collect(Collectors.toList());
        } else {
            objectRef.instance = this.convertViaSchema(context, schemaNode, inputData, input.inspect());
        }
    }

    private Object convertViaSchema(RuntimeContextBuilder.DALRuntimeContext context, SchemaNode schemaNode, Data element, String input) {
        try {
            return schemaNode.getConstructorViaSchema(context).apply(element);
        }
        catch (IllegalTypeException exception) {
            throw new AssertionFailure(exception.assertionFailureMessage(input.isEmpty() ? input : input + " ", schemaNode), schemaNode.getPositionBegin());
        }
    }

    static class ObjectRef {
        public Object instance;

        ObjectRef() {
        }
    }
}

