/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.table;

import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.DALOperator;
import com.github.leeonky.dal.ast.table.EmptyTableRowKeyType;
import com.github.leeonky.dal.ast.table.RowKeyType;
import com.github.leeonky.dal.ast.table.RowNode;
import com.github.leeonky.dal.ast.table.TableHead;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.interpreter.FunctionUtil;
import com.github.leeonky.interpreter.InterpreterException;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class TableBody
extends DALNode {
    private static final RowKeyType EMPTY_TABLE_ROW_KEY = new EmptyTableRowKeyType();
    private final List<RowNode> rows;
    private final RowKeyType rowKeyType;

    public TableBody(List<? extends DALNode> rows) {
        this(rows, InterpreterException.Position.Type.LINE);
    }

    public TableBody(List<? extends DALNode> rows, InterpreterException.Position.Type type) {
        this.rows = rows.stream().map(RowNode.class::cast).collect(Collectors.toList());
        this.rowKeyType = this.resolveRowKeyType(type);
    }

    public RowKeyType resolveRowKeyType(InterpreterException.Position.Type type) {
        return this.rows.stream().reduce(EMPTY_TABLE_ROW_KEY, (last, rowNode) -> {
            try {
                return rowNode.combineRowKey((RowKeyType)last);
            }
            catch (IllegalArgumentException ignored) {
                throw new SyntaxException("Row index should be consistent", rowNode.getPositionBegin(), type).multiPosition(this.rows.get(0).getPositionBegin(), type);
            }
        }, FunctionUtil.notAllowParallelReduce());
    }

    @Override
    public String inspect() {
        return this.rows.stream().map(RowNode::inspect).collect(Collectors.joining());
    }

    public DALNode transformToListScope(Data actual, DALOperator operator, Comparator<Object> comparator) {
        return this.rowKeyType.transformToVerificationNode(actual, operator, this.rows, comparator);
    }

    public RowNode getDataRowByDataIndex(int row) {
        return (RowNode)this.rows.stream().filter(RowNode::isData).collect(Collectors.toList()).get(row);
    }

    public TableBody checkTable(TableHead tableHead) {
        this.rows.forEach(tableHead::checkSize);
        return this;
    }
}

