/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface Flatten {
    default public Optional<String> removeExpectedField(Set<String> fields, Object prefix, Object postfix) {
        List removed = fields.stream().filter(field -> this.predicate((String)field, this.buildField(prefix, postfix))).collect(Collectors.toList());
        if (removed.size() > 1) {
            throw new IllegalArgumentException("More than one expected field found: " + removed);
        }
        return removed.stream().findFirst();
    }

    default public boolean predicate(String candidate, String field) {
        return candidate.equalsIgnoreCase(field);
    }

    default public String buildField(Object prefix, Object postfix) {
        return String.format("%s%s", prefix, postfix);
    }
}

