/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.interpreter;

import com.github.leeonky.interpreter.FunctionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class InterpreterException
extends RuntimeException {
    private final List<Position> positions = new ArrayList<Position>();

    public InterpreterException(String message, int position) {
        this(message, position, Position.Type.CHAR);
    }

    public InterpreterException(String message, int position, Position.Type type) {
        super(message);
        this.positions.add(new Position(type, position));
    }

    public <E extends InterpreterException> E multiPosition(int positionBegin, Position.Type type) {
        this.positions.add(new Position(type, positionBegin));
        return (E)this;
    }

    @Deprecated
    public int getPosition() {
        return this.positions.get(0).position;
    }

    public String show(String code) {
        return this.show(code, 0);
    }

    public String show(String code, int offset) {
        this.positions.sort(Comparator.comparingInt(o -> ((Position)o).position).reversed().thenComparing(Comparator.comparing(o -> ((Position)o).type).reversed()));
        return this.positions.stream().map(position -> position.offset(offset)).reduce(code.substring(offset), (r, p) -> p.process((String)r), FunctionUtil.notAllowParallelReduce());
    }

    public void setType(Position.Type type) {
        if (this.positions.size() > 0) {
            this.positions.set(0, new Position(type, this.positions.get(0).position));
        }
    }

    public void clearPosition() {
        this.positions.clear();
    }

    public static class Position {
        private final Type type;
        private final int position;

        public Position(Type type, int position) {
            this.type = type;
            this.position = position;
        }

        public String process(String code) {
            int endLineIndex = code.indexOf(10, this.position);
            endLineIndex = endLineIndex == -1 ? code.length() : endLineIndex;
            return code.substring(0, endLineIndex) + "\n" + this.type.markLine(code, this.position, code.lastIndexOf(10, this.position), endLineIndex) + code.substring(endLineIndex);
        }

        public Position offset(int offset) {
            return offset == 0 ? this : new Position(this.type, this.position - offset);
        }

        public static enum Type {
            CHAR{

                @Override
                protected String markLine(String code, int position, int startLineIndex, int endLineIndex) {
                    return String.join((CharSequence)"", Collections.nCopies(Type.charCountBeforeMark(code, position, startLineIndex), " ")) + "^";
                }
            }
            ,
            LINE{

                @Override
                protected String markLine(String code, int position, int startLineIndex, int endLineIndex) {
                    return String.join((CharSequence)"", Collections.nCopies(Type.charCountBeforeMark(code, endLineIndex, startLineIndex), "^"));
                }
            };


            private static int charCountBeforeMark(String code, int position, int startLineIndex) {
                int fullWidthCharCount = (int)code.chars().limit(position).skip(startLineIndex == -1 ? 0L : (long)startLineIndex).filter(Type::isFullWidth).count();
                return position - startLineIndex + fullWidthCharCount - 1;
            }

            private static boolean isFullWidth(int c) {
                return !(0 <= c && c <= 255 || 65377 <= c && c <= 65500 || 65512 <= c && c <= 65518);
            }

            protected abstract String markLine(String var1, int var2, int var3, int var4);
        }
    }
}

