/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.ExecutableNode;
import com.github.leeonky.dal.ast.SymbolNode;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ElementAccessException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.util.BeanClass;

public class ListMappingNode
extends DALNode
implements ExecutableNode {
    private final SymbolNode symbolNode;

    public ListMappingNode(DALNode symbolNode) {
        this.symbolNode = (SymbolNode)symbolNode;
        this.setPositionBegin(symbolNode.getPositionBegin());
    }

    @Override
    public String inspect() {
        return this.symbolNode.inspect() + "[]";
    }

    @Override
    public Data getValue(Data data, RuntimeContextBuilder.DALRuntimeContext context) {
        try {
            if (data.isList()) {
                return data.mapList(this.symbolNode.getRootSymbolName());
            }
            throw new RuntimeException(String.format("The instance of '%s' is not a list", BeanClass.createFrom((Object)data.getInstance()).getName()), this.getPositionBegin());
        }
        catch (ElementAccessException e) {
            throw e.toDalError(this.symbolNode.getPositionBegin());
        }
    }
}

