/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.AssertionFailure;
import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.SchemaNode;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.IllegalTypeException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class SchemaComposeNode
extends DALNode {
    private final List<SchemaNode> schemas;
    private final boolean isList;

    public SchemaComposeNode(List<SchemaNode> schemas, boolean isList) {
        this.schemas = schemas;
        this.isList = isList;
    }

    @Override
    public String inspect() {
        Collector<CharSequence, ?, String> joining = this.isList ? Collectors.joining(" / ", "[", "]") : Collectors.joining(" / ");
        return this.schemas.stream().map(SchemaNode::inspect).collect(joining);
    }

    public Data verify(DALNode input, RuntimeContextBuilder.DALRuntimeContext context) {
        try {
            List instanceBySchema = this.schemas.stream().map(schemaNode -> this.verifyAndConvertAsSchemaType(context, (SchemaNode)((Object)schemaNode), input)).collect(Collectors.toList());
            return context.wrap(instanceBySchema.get(instanceBySchema.size() - 1), this.schemas.get(0).inspect(), this.isList);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e.getMessage(), this.getPositionBegin());
        }
    }

    private Object verifyAndConvertAsSchemaType(RuntimeContextBuilder.DALRuntimeContext context, SchemaNode schemaNode, DALNode input) {
        Data inputData = input.evaluateData(context);
        if (this.isList) {
            if (!inputData.isList()) {
                throw new SyntaxException("Expecting a list but was " + inputData.inspect(), input.getPositionBegin());
            }
            AtomicInteger index = new AtomicInteger(0);
            return inputData.getDataList().stream().map(element -> this.convertViaSchema(context, schemaNode, (Data)element, String.format("%s[%d]", input.inspect(), index.getAndIncrement()))).collect(Collectors.toList());
        }
        return this.convertViaSchema(context, schemaNode, inputData, input.inspect());
    }

    private Object convertViaSchema(RuntimeContextBuilder.DALRuntimeContext context, SchemaNode schemaNode, Data element, String input) {
        try {
            return schemaNode.getValueConstructorViaSchema(context).apply(element);
        }
        catch (IllegalTypeException exception) {
            throw new AssertionFailure(exception.assertionFailureMessage(input.isEmpty() ? input : input + " ", schemaNode), schemaNode.getPositionBegin());
        }
    }
}

