/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.table;

import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.InputNode;
import com.github.leeonky.dal.ast.SortGroupNode;
import com.github.leeonky.dal.ast.TableNode;
import com.github.leeonky.dal.ast.table.HeaderNode;
import com.github.leeonky.dal.ast.table.TableRowNode;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TableHeadRow
extends DALNode {
    private final List<HeaderNode> headers;

    public TableHeadRow(List<DALNode> headers) {
        this.headers = headers.stream().map(HeaderNode.class::cast).collect(Collectors.toList());
    }

    @Override
    public String inspect() {
        return TableNode.printLine(this.headers) + "\n";
    }

    public Comparator<Object> collectComparator(RuntimeContextBuilder.DALRuntimeContext context) {
        return this.headers.stream().sorted(HeaderNode.bySequence()).map(headerNode -> headerNode.comparator(context)).reduce(Comparator::thenComparing).orElse(SortGroupNode.NOP_COMPARATOR);
    }

    public HeaderNode getHeader(int index) {
        if (index >= this.headers.size()) {
            return new HeaderNode(SortGroupNode.NO_SEQUENCE, InputNode.INPUT_NODE, Optional.empty());
        }
        return this.headers.get(index);
    }

    public void checkDataCellSize(TableRowNode rowNode) {
        rowNode.checkSize(this.headers.size());
    }

    public TableHeadRow merge(final TableHeadRow tableHeadRow) {
        return new TableHeadRow((List<DALNode>)new ArrayList<DALNode>(){
            {
                this.addAll(TableHeadRow.this.headers);
                this.addAll(tableHeadRow.headers);
            }
        });
    }
}

