/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.runtime.PropertyAccessor;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.NoSuchAccessorException;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class JavaClassPropertyAccessor<T>
implements PropertyAccessor<T> {
    private final RuntimeContextBuilder runtimeContextBuilder;
    private final BeanClass<T> beanClass;

    public JavaClassPropertyAccessor(RuntimeContextBuilder runtimeContextBuilder, BeanClass<T> type) {
        this.runtimeContextBuilder = runtimeContextBuilder;
        this.beanClass = type;
    }

    @Override
    public Object getValue(T instance, Object property) {
        try {
            return this.beanClass.getPropertyValue(instance, (String)property);
        }
        catch (NoSuchAccessorException ignore) {
            try {
                return this.beanClass.getType().getMethod((String)property, new Class[0]).invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                return this.runtimeContextBuilder.invokeExtensionMethod(instance, (String)property, instance.getClass().getName());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public Set<Object> getPropertyNames(T instance) {
        return new LinkedHashSet<Object>(this.beanClass.getPropertyReaders().keySet());
    }

    @Override
    public boolean isNull(T instance) {
        return Objects.equals(instance, null);
    }
}

