/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal;

import com.github.leeonky.dal.DALFactory;
import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.compiler.Compiler;
import com.github.leeonky.dal.compiler.Notations;
import com.github.leeonky.dal.runtime.Extension;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.util.TextUtil;
import com.github.leeonky.interpreter.SourceCode;
import com.github.leeonky.interpreter.SyntaxException;
import com.github.leeonky.util.Classes;
import java.util.List;
import java.util.stream.Collectors;

public class DAL {
    private final Compiler compiler = new Compiler();
    private final RuntimeContextBuilder runtimeContextBuilder = new RuntimeContextBuilder();
    private static final ThreadLocal<DAL> instance = new ThreadLocal();

    public static synchronized DAL getInstance() {
        if (instance.get() == null) {
            instance.set(DALFactory.create());
        }
        return instance.get();
    }

    public RuntimeContextBuilder getRuntimeContextBuilder() {
        return this.runtimeContextBuilder;
    }

    public <T> List<T> evaluateAll(Object input, String expressions) {
        RuntimeContextBuilder.DALRuntimeContext runtimeContext = this.runtimeContextBuilder.build(input);
        return this.compiler.compile(new SourceCode(this.format(expressions), Notations.LINE_COMMENTS), runtimeContext).stream().map(node -> node.evaluate(runtimeContext)).collect(Collectors.toList());
    }

    public <T> T evaluate(Object input, String expression) {
        RuntimeContextBuilder.DALRuntimeContext DALRuntimeContext2 = this.runtimeContextBuilder.build(input);
        List<DALNode> nodes = this.compiler.compile(new SourceCode(this.format(expression), Notations.LINE_COMMENTS), DALRuntimeContext2);
        if (nodes.size() > 1) {
            throw new SyntaxException("more than one expression", this.getOperandPosition(nodes.get(1)));
        }
        return (T)nodes.get(0).evaluate(DALRuntimeContext2);
    }

    private int getOperandPosition(DALNode node) {
        return node.getPositionBegin() == 0 ? node.getOperandPosition() : node.getPositionBegin();
    }

    private String format(String expression) {
        return String.join((CharSequence)"\n", TextUtil.lines(expression));
    }

    public DAL extend() {
        Classes.subTypesOf(Extension.class, (String)"com.github.leeonky.dal.extensions").forEach(c -> ((Extension)Classes.newInstance((Class)c, (Object[])new Object[0])).extend(this));
        Classes.subTypesOf(Extension.class, (String)"com.github.leeonky.extensions.dal").forEach(c -> ((Extension)Classes.newInstance((Class)c, (Object[])new Object[0])).extend(this));
        return this;
    }
}

