/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node.table;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.table.EmptyTableRowType;
import com.github.leeonky.dal.ast.node.table.RowType;
import com.github.leeonky.dal.ast.node.table.TableHeadRow;
import com.github.leeonky.dal.ast.node.table.TableRowNode;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.interpreter.InterpreterException;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class TableBody
extends DALNode {
    private static final RowType EMPTY_TABLE_ROW_TYPE = new EmptyTableRowType();
    private final List<TableRowNode> rows;
    private final RowType rowType;

    public TableBody(List<? extends DALNode> rows) {
        this(rows, InterpreterException.Position.Type.LINE);
    }

    public TableBody(List<? extends DALNode> rows, InterpreterException.Position.Type type) {
        this.rows = rows.stream().map(TableRowNode.class::cast).collect(Collectors.toList());
        this.rowType = this.resolveRowType(type);
    }

    public RowType resolveRowType(InterpreterException.Position.Type type) {
        return this.rows.stream().reduce(EMPTY_TABLE_ROW_TYPE, (last, rowNode) -> {
            try {
                return rowNode.mergeRowTypeBy((RowType)last);
            }
            catch (IllegalArgumentException ignored) {
                throw new SyntaxException("Row index should be consistent", rowNode.getPositionBegin(), type).multiPosition(this.rows.get(0).getPositionBegin(), type);
            }
        }, RowType::merge);
    }

    @Override
    public String inspect() {
        return this.rows.stream().map(TableRowNode::inspect).collect(Collectors.joining("\n"));
    }

    public DALNode convertToVerificationNode(Data actual, DALOperator operator, Comparator<Object> comparator) {
        return this.rowType.constructVerificationNode(actual, this.rows.stream().map(rowNode -> rowNode.constructVerificationClause(operator, this.rowType)), comparator);
    }

    public TableRowNode dataRowSkipEllipsis(int indexSkipEllipsis) {
        return (TableRowNode)((Object)this.rows.stream().filter(TableRowNode::isData).collect(Collectors.toList()).get(indexSkipEllipsis));
    }

    public TableBody checkFormat(TableHeadRow headRow) {
        this.rows.forEach(headRow::checkDataCellSize);
        return this;
    }
}

