/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.format;

import com.github.leeonky.util.function.Comparator;
import java.util.Objects;

public interface Type<T> {
    public static <T> Type<T> equalTo(final T expect) {
        return new Type<T>(){

            @Override
            public boolean verify(T actual) {
                return Objects.equals(expect, actual);
            }

            @Override
            public String errorMessage(String field, Object actual) {
                return String.format("Expecting field `%s` [%s] to be equal to [%s], but was not.", field, actual, expect);
            }
        };
    }

    public static <T> Type<T> nullReference() {
        return new Type<T>(){

            @Override
            public boolean verify(T obj) {
                return Objects.isNull(obj);
            }

            @Override
            public String errorMessage(String field, Object actual) {
                return String.format("Expecting field `%s` [%s] to be null, but was not.", field, actual);
            }
        };
    }

    public static <T extends Comparable<T>> Type<T> lessThan(T value) {
        return Type.compare(value, (Comparator<Integer>)Comparator.lessThan((Comparable)Integer.valueOf(0)), "less than");
    }

    public static <T extends Comparable<T>> Type<T> greaterThan(T value) {
        return Type.compare(value, (Comparator<Integer>)Comparator.greaterThan((Comparable)Integer.valueOf(0)), "greater than");
    }

    public static <T extends Comparable<T>> Type<T> lessOrEqualTo(T value) {
        return Type.compare(value, (Comparator<Integer>)Comparator.lessOrEqualTo((Comparable)Integer.valueOf(0)), "less or equal to");
    }

    public static <T extends Comparable<T>> Type<T> greaterOrEqualTo(T value) {
        return Type.compare(value, (Comparator<Integer>)Comparator.greaterOrEqualTo((Comparable)Integer.valueOf(0)), "greater or equal to");
    }

    public static <T extends Comparable<T>> Type<T> compare(T value, Comparator<Integer> comparator, String message) {
        return new ComparableType<T>(comparator, value, message);
    }

    public boolean verify(T var1);

    public String errorMessage(String var1, Object var2);

    public static class ComparableType<T extends Comparable<T>>
    implements Type<T> {
        private final Comparator<Integer> comparator;
        private final T value;
        private final String message;

        public ComparableType(Comparator<Integer> comparator, T value, String message) {
            this.comparator = comparator;
            this.value = value;
            this.message = message;
        }

        @Override
        public boolean verify(T actual) {
            return this.comparator.compareTo((Comparable)Integer.valueOf(((Comparable)Objects.requireNonNull(actual)).compareTo(this.value)));
        }

        @Override
        public String errorMessage(String field, Object actual) {
            return String.format("Expecting field `%s` [%s] to be %s [%s], but was not.", field, actual, this.message, this.value);
        }
    }
}

