/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime.inspector;

import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.inspector.CacheableInspector;
import com.github.leeonky.dal.runtime.inspector.InspectorCache;
import com.github.leeonky.dal.util.TextUtil;
import com.github.leeonky.util.Classes;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MapInspector
extends CacheableInspector {
    public MapInspector(Data data) {
        super(data);
    }

    @Override
    public String cachedInspect(String path, InspectorCache cache) {
        String type = this.data.getInstance() instanceof Map ? "" : Classes.getClassName((Object)this.data.getInstance()) + " ";
        Set<Object> fieldNames = this.data.getFieldNames();
        if (fieldNames.isEmpty()) {
            return type + "{}";
        }
        return type + fieldNames.stream().map(o -> {
            Data value;
            try {
                value = this.data.getValue(o);
            }
            catch (Exception e) {
                return o + ": *throw* " + e;
            }
            return o + ": " + value.buildInspector().dump(path + "." + o, cache);
        }).map(TextUtil::indent).collect(Collectors.joining(",\n", "{\n", "\n}"));
    }
}

