/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime.schema;

import com.github.leeonky.dal.runtime.IllegalFieldException;
import com.github.leeonky.dal.runtime.IllegalTypeException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.schema.Actual;
import com.github.leeonky.dal.runtime.schema.Expect;
import com.github.leeonky.interpreter.TriplePredicate;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.function.IfFactory;
import com.github.leeonky.util.function.When;
import java.util.stream.Collectors;

public class Verification {
    private static final IfFactory.Factory<Expect, TriplePredicate<Verification, RuntimeContextBuilder.DALRuntimeContext, Actual>> VERIFICATIONS = When.when(Expect::isSchema).then(Verification::schema).when(Expect::isFormatter).then(Verification::formatter).when(Expect::isSchemaValue).then(Verification.combine((TriplePredicate<Verification, RuntimeContextBuilder.DALRuntimeContext, Actual>)((TriplePredicate)Verification::valueStructure), (TriplePredicate<Verification, RuntimeContextBuilder.DALRuntimeContext, Actual>)((TriplePredicate)Verification::valueContent))).when(Expect::isMap).then(Verification.combine((TriplePredicate<Verification, RuntimeContextBuilder.DALRuntimeContext, Actual>)((TriplePredicate)Verification::mapStructure), (TriplePredicate<Verification, RuntimeContextBuilder.DALRuntimeContext, Actual>)((TriplePredicate)Verification::mapContent))).when(Expect::isCollection).then(Verification.combine((TriplePredicate<Verification, RuntimeContextBuilder.DALRuntimeContext, Actual>)((TriplePredicate)Verification::collectionStructure), (TriplePredicate<Verification, RuntimeContextBuilder.DALRuntimeContext, Actual>)((TriplePredicate)Verification::collectionContent))).when(Expect::isSchemaType).then(Verification.combine((TriplePredicate<Verification, RuntimeContextBuilder.DALRuntimeContext, Actual>)((TriplePredicate)Verification::typeStructure), (TriplePredicate<Verification, RuntimeContextBuilder.DALRuntimeContext, Actual>)((TriplePredicate)Verification::typeContent))).orElse(Verification.combine((TriplePredicate<Verification, RuntimeContextBuilder.DALRuntimeContext, Actual>)((TriplePredicate)Verification::structure), (TriplePredicate<Verification, RuntimeContextBuilder.DALRuntimeContext, Actual>)((TriplePredicate)Verification::content)));
    private final Expect expect;

    private Verification(Expect expect) {
        this.expect = expect;
    }

    public static Verification expect(Expect expect) {
        return new Verification(expect);
    }

    public static boolean errorLog(String format, Object ... params) {
        throw new IllegalTypeException(String.format(format, params));
    }

    private static TriplePredicate<Verification, RuntimeContextBuilder.DALRuntimeContext, Actual> combine(TriplePredicate<Verification, RuntimeContextBuilder.DALRuntimeContext, Actual> structure, TriplePredicate<Verification, RuntimeContextBuilder.DALRuntimeContext, Actual> content) {
        return (verification, context, actual) -> verification.expect.structure() ? structure.test(verification, context, actual) : content.test(verification, context, actual);
    }

    public boolean verify(RuntimeContextBuilder.DALRuntimeContext runtimeContext, Actual actual) {
        return ((TriplePredicate)VERIFICATIONS.get((Object)this.expect)).test((Object)this, (Object)runtimeContext, (Object)actual);
    }

    private boolean valueStructure(RuntimeContextBuilder.DALRuntimeContext runtimeContext, Actual actual) {
        return actual.convertAble(this.expect.getGenericType(0).orElseThrow(actual::invalidGenericType), this.expect.inspectExpectType());
    }

    private boolean valueContent(RuntimeContextBuilder.DALRuntimeContext runtimeContext, Actual actual) {
        try {
            return this.expect.verifyValue(actual::verifyValue);
        }
        catch (IllegalFieldException ignore) {
            throw actual.invalidGenericType();
        }
    }

    private boolean mapStructure(RuntimeContextBuilder.DALRuntimeContext context, Actual actual) {
        BeanClass<?> type = this.expect.getGenericType(1).orElseThrow(actual::invalidGenericType);
        return actual.fieldNames().allMatch(key -> Verification.expect(this.expect.sub((BeanClass<Object>)type, key)).verify(context, actual.sub(key)));
    }

    private boolean mapContent(RuntimeContextBuilder.DALRuntimeContext context, Actual actual) {
        return actual.verifySize(Actual::fieldNames, this.expect.mapKeysSize()) && this.mapStructure(context, actual);
    }

    private boolean collectionStructure(RuntimeContextBuilder.DALRuntimeContext context, Actual actual) {
        return actual.indexStream().allMatch(index -> Verification.expect(this.expect.sub((int)index)).verify(context, actual.sub((Integer)index)));
    }

    private boolean collectionContent(RuntimeContextBuilder.DALRuntimeContext context, Actual actual) {
        return actual.verifySize(Actual::indexStream, this.expect.collectionSize()) && this.collectionStructure(context, actual);
    }

    private boolean formatter(RuntimeContextBuilder.DALRuntimeContext runtimeContext, Actual actual) {
        return actual.verifyFormatter(this.expect.extractFormatter());
    }

    private boolean typeContent(RuntimeContextBuilder.DALRuntimeContext runtimeContext, Actual actual) {
        return actual.verifyType(this.expect.extractType());
    }

    private boolean typeStructure(RuntimeContextBuilder.DALRuntimeContext r, Actual actual) {
        return this.expect.isInstanceType(actual);
    }

    private boolean structure(RuntimeContextBuilder.DALRuntimeContext runtimeContext, Actual actual) {
        return this.expect.isInstanceOf(actual);
    }

    private boolean content(RuntimeContextBuilder.DALRuntimeContext runtimeContext, Actual actual) {
        return this.expect.equals(actual);
    }

    private boolean schema(RuntimeContextBuilder.DALRuntimeContext runtimeContext, Actual actual) {
        return this.expect.asSchema(actual).verify(runtimeContext, actual, actual.fieldNames().filter(String.class::isInstance).map(Object::toString).collect(Collectors.toSet()));
    }
}

