/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node.table;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.table.TableBody;
import com.github.leeonky.dal.ast.node.table.TableHeadRow;
import com.github.leeonky.dal.ast.node.table.TableRowNode;
import com.github.leeonky.dal.ast.node.table.TransposedRowNode;
import com.github.leeonky.dal.ast.node.table.TransposedTableHead;
import com.github.leeonky.interpreter.InterpreterException;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TransposedTableBody
extends DALNode {
    private final List<TransposedRowNode> rows;

    public TransposedTableBody(List<DALNode> rows) {
        this.rows = rows.stream().map(TransposedRowNode.class::cast).collect(Collectors.toList());
    }

    public TransposedTableBody checkFormat(TransposedTableHead tableHead) {
        this.checkCellSize(tableHead);
        this.replaceEmptyCell();
        return this;
    }

    private void replaceEmptyCell() {
        TransposedRowNode firstRow = this.rows.get(0);
        this.rows.stream().skip(1L).forEach(row -> row.replaceEmptyCell(firstRow));
    }

    private void checkCellSize(TransposedTableHead tableHead) {
        this.rows.forEach(tableHead::checkSize);
        Map<Integer, List<TransposedRowNode>> rowsByCount = this.rows.stream().collect(Collectors.groupingBy(TransposedRowNode::cellCount));
        if (rowsByCount.size() > 1) {
            throw new SyntaxException("Different cell size", new ArrayList<List<TransposedRowNode>>(rowsByCount.values()).get(1).get(0).getPositionBegin(), InterpreterException.Position.Type.ROW);
        }
    }

    public TableBody transpose(TransposedTableHead tableHead) {
        return new TableBody(this.rows.stream().map(rowNode -> rowNode.transpose(tableHead)).reduce(this::merge).orElse(Collections.emptyList()), InterpreterException.Position.Type.CHAR);
    }

    private List<TableRowNode> merge(final List<TableRowNode> rows1, final List<TableRowNode> rows2) {
        return new ArrayList<TableRowNode>(){
            {
                for (int i = 0; i < rows1.size(); ++i) {
                    this.add(((TableRowNode)((Object)rows1.get(i))).merge((TableRowNode)((Object)rows2.get(i))));
                }
            }
        };
    }

    public TableHeadRow transposeHead() {
        return new TableHeadRow(this.rows.stream().map(TransposedRowNode::getHeader).collect(Collectors.toList()));
    }

    @Override
    public String inspect() {
        return this.rows.stream().map(TransposedRowNode::inspect).collect(Collectors.joining("\n"));
    }
}

