/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime.inspector;

import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.inspector.CacheableInspector;
import com.github.leeonky.dal.runtime.inspector.InspectorCache;
import com.github.leeonky.dal.util.TextUtil;
import com.github.leeonky.util.Classes;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MapInspector
extends CacheableInspector {
    public MapInspector(Data data) {
        super(data);
    }

    @Override
    public String cachedInspect(String path, InspectorCache cache) {
        String type = this.type();
        Set<Object> fieldNames = this.getFieldNames();
        if (fieldNames.isEmpty()) {
            return type + "{}";
        }
        return type + fieldNames.stream().map(o -> this.dumpEntry(path, cache, o)).map(TextUtil::indent).collect(Collectors.joining(",\n", "{\n", "\n}"));
    }

    private String dumpEntry(String path, InspectorCache cache, Object o) {
        Data value;
        try {
            value = this.data.getValue(o);
        }
        catch (Exception e) {
            return this.key(o) + ": *throw* " + e;
        }
        return this.key(o) + ": " + value.buildInspector().dump(path + "." + o, cache);
    }

    protected String key(Object o) {
        return String.valueOf(o);
    }

    protected Set<Object> getFieldNames() {
        return this.data.getFieldNames();
    }

    protected String type() {
        return this.data.getInstance() instanceof Map ? "" : Classes.getClassName((Object)this.data.getInstance()) + " ";
    }
}

