/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.opt.Equal;
import com.github.leeonky.dal.ast.opt.Matcher;
import com.github.leeonky.dal.runtime.AssertionFailure;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeException;
import java.util.regex.Pattern;

public class RegexNode
extends DALNode {
    private final Pattern pattern;

    public RegexNode(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public String inspect() {
        return String.format("/%s/", this.pattern.toString());
    }

    @Override
    public boolean verify(DALNode actualNode, Equal operator, RuntimeContextBuilder.DALRuntimeContext context) {
        Data actual = actualNode.evaluateData(context);
        if (actual.getInstance() instanceof String) {
            return AssertionFailure.assertRegexMatches(this.pattern, (String)actual.getInstance(), this.getPositionBegin());
        }
        throw new RuntimeException("Operator = before regex need a string input value", operator.getPosition());
    }

    @Override
    public boolean verify(DALNode actualNode, Matcher operator, RuntimeContextBuilder.DALRuntimeContext context) {
        Data actual = actualNode.evaluateData(context);
        return AssertionFailure.assertRegexMatches(this.pattern, (String)actual.convert(String.class).getInstance(), actual, this.getPositionBegin());
    }
}

