/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.format;

import com.github.leeonky.dal.format.Type;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.IllegalFieldException;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.function.Comparator;
import java.util.Objects;

public interface Value<T>
extends Type<T> {
    public static <T> Value<T> equalTo(final T value) {
        return new Value<T>(){

            @Override
            public boolean verify(T actual) {
                return Objects.equals(value, actual);
            }

            @Override
            public String errorMessage(String field, Object actual) {
                return String.format("Expecting field `%s` [%s] to be equal to [%s], but was not.", field, actual, value);
            }
        };
    }

    public static <T> Value<T> nullReference() {
        return new Value<T>(){

            @Override
            public boolean verify(T actual) {
                return actual == null;
            }

            @Override
            public String errorMessage(String field, Object actual) {
                return String.format("Expecting field `%s` [%s] to be null, but was not.", field, actual);
            }
        };
    }

    public static <T extends Comparable<T>> Value<T> lessThan(T value) {
        return Value.compare(value, (Comparator<Integer>)Comparator.lessThan((Comparable)Integer.valueOf(0)), "less than");
    }

    public static <T extends Comparable<T>> Value<T> greaterThan(T value) {
        return Value.compare(value, (Comparator<Integer>)Comparator.greaterThan((Comparable)Integer.valueOf(0)), "greater than");
    }

    public static <T extends Comparable<T>> Value<T> lessOrEqualTo(T value) {
        return Value.compare(value, (Comparator<Integer>)Comparator.lessOrEqualTo((Comparable)Integer.valueOf(0)), "less or equal to");
    }

    public static <T extends Comparable<T>> Value<T> greaterOrEqualTo(T value) {
        return Value.compare(value, (Comparator<Integer>)Comparator.greaterOrEqualTo((Comparable)Integer.valueOf(0)), "greater or equal to");
    }

    public static <T extends Comparable<T>> Value<T> compare(T value, Comparator<Integer> comparator, String valueName) {
        return new ComparableValue<T>(comparator, value, valueName);
    }

    @Override
    public boolean verify(T var1);

    @Override
    default public String errorMessage(String field, Object actual) {
        return String.format("Field `%s` is invalid", field);
    }

    default public T convertAs(Data actual, BeanClass<?> type) {
        if (type == null) {
            throw new IllegalFieldException();
        }
        return (T)actual.convert(type.getType()).getInstance();
    }

    public static class ComparableValue<T extends Comparable<T>>
    extends Type.ComparableType<T>
    implements Value<T> {
        public ComparableValue(Comparator<Integer> comparator, T value, String valueName) {
            super(comparator, value, valueName);
        }
    }
}

