/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.runtime.DalException;
import com.github.leeonky.dal.runtime.Data;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AssertionFailure
extends DalException {
    public AssertionFailure(String message, int position) {
        super(message, position);
    }

    public static void assertUnexpectedFields(Set<Object> dataFields, String element, int position) {
        if (!dataFields.isEmpty()) {
            throw new AssertionFailure(String.format("Unexpected fields %s%s", dataFields.stream().map(s -> s instanceof String ? String.format("`%s`", s) : s.toString()).collect(Collectors.joining(", ")), element.isEmpty() ? "" : " in " + element), position);
        }
    }

    public static boolean assertRegexMatches(Pattern pattern, String actual, int position) {
        if (!pattern.matcher(actual).matches()) {
            throw new AssertionFailure(String.format("Expected to match: /%s/\nActual: <%s>", pattern, actual), position);
        }
        return true;
    }

    public static boolean assertRegexMatches(Pattern pattern, String converted, Data input, int position) {
        if (!pattern.matcher(converted).matches()) {
            throw new AssertionFailure(String.format("Expected to match: /%s/\nActual: <%s> converted from: %s", pattern, converted, input.inspect()), position);
        }
        return true;
    }
}

