/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.format.Formatter;
import com.github.leeonky.dal.runtime.Checker;
import com.github.leeonky.dal.runtime.ClassKeyMap;
import com.github.leeonky.dal.runtime.ConditionalChecker;
import com.github.leeonky.dal.runtime.ConstructorViaSchema;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ExpectActual;
import com.github.leeonky.dal.runtime.IllegalTypeException;
import com.github.leeonky.dal.runtime.InvalidPropertyException;
import com.github.leeonky.dal.runtime.JavaClassPropertyAccessor;
import com.github.leeonky.dal.runtime.ListAccessor;
import com.github.leeonky.dal.runtime.MetaData;
import com.github.leeonky.dal.runtime.NameStrategy;
import com.github.leeonky.dal.runtime.PartialProperties;
import com.github.leeonky.dal.runtime.PartialPropertyStack;
import com.github.leeonky.dal.runtime.PropertyAccessor;
import com.github.leeonky.dal.runtime.Result;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.dal.runtime.SchemaType;
import com.github.leeonky.dal.runtime.TextFormatter;
import com.github.leeonky.dal.runtime.UserLiteralRule;
import com.github.leeonky.dal.runtime.inspector.Inspector;
import com.github.leeonky.dal.runtime.inspector.InspectorBuilder;
import com.github.leeonky.dal.runtime.inspector.ValueInspector;
import com.github.leeonky.dal.runtime.schema.Actual;
import com.github.leeonky.dal.runtime.schema.Expect;
import com.github.leeonky.dal.runtime.schema.Verification;
import com.github.leeonky.dal.type.ExtensionName;
import com.github.leeonky.dal.type.Schema;
import com.github.leeonky.interpreter.RuntimeContext;
import com.github.leeonky.interpreter.SyntaxException;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.Converter;
import com.github.leeonky.util.InvocationException;
import com.github.leeonky.util.NumberType;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RuntimeContextBuilder {
    private final ClassKeyMap<PropertyAccessor<Object>> propertyAccessors = new ClassKeyMap();
    private final ClassKeyMap<ListAccessor<Object>> listAccessors = new ClassKeyMap();
    private final ClassKeyMap<Function<Object, Object>> objectImplicitMapper = new ClassKeyMap();
    private final Map<String, ConstructorViaSchema> valueConstructors = new LinkedHashMap<String, ConstructorViaSchema>();
    private final Map<String, BeanClass<?>> schemas = new HashMap();
    private final Set<Method> extensionMethods = new HashSet<Method>();
    private final Map<Object, Function<MetaData, Object>> metaProperties = new HashMap<Object, Function<MetaData, Object>>();
    private final List<UserLiteralRule> userDefinedLiterals = new ArrayList<UserLiteralRule>();
    private final NumberType numberType = new NumberType();
    private final Map<Method, BiFunction<Object, List<Object>, List<Object>>> curryingMethodArgRanges = new HashMap<Method, BiFunction<Object, List<Object>, List<Object>>>();
    private final Map<String, TextFormatter> textFormatterMap = new LinkedHashMap<String, TextFormatter>();
    private Converter converter = Converter.getInstance();
    private final ClassKeyMap<Checker> equalsCheckers = new ClassKeyMap();
    private final ClassKeyMap<Checker> matchesCheckers = new ClassKeyMap();
    private final ClassKeyMap<InspectorBuilder> inspectorBuilders = new ClassKeyMap();

    public RuntimeContextBuilder registerMetaProperty(Object property, Function<MetaData, Object> function) {
        this.metaProperties.put(property, function);
        return this;
    }

    public RuntimeContextBuilder registerTextFormatter(String name, TextFormatter formatter) {
        this.textFormatterMap.put(name, formatter);
        return this;
    }

    public DALRuntimeContext build(Object inputValue) {
        return new DALRuntimeContext(inputValue);
    }

    public RuntimeContextBuilder registerValueFormat(Formatter<?, ?> formatter) {
        return this.registerValueFormat(formatter.getFormatterName(), formatter);
    }

    public RuntimeContextBuilder registerValueFormat(String name, Formatter<?, ?> formatter) {
        this.valueConstructors.put(name, (o, c) -> formatter.transform(o.getInstance()));
        return this;
    }

    public RuntimeContextBuilder registerSchema(Class<? extends Schema> schema) {
        return this.registerSchema(NameStrategy.SIMPLE_NAME, schema);
    }

    public RuntimeContextBuilder registerSchema(String name, Class<? extends Schema> schema) {
        this.schemas.put(name, BeanClass.create(schema));
        return this.registerSchema(name, (Data data, DALRuntimeContext context) -> Verification.expect(new Expect((BeanClass<Object>)BeanClass.create((Class)schema), null)).verify((DALRuntimeContext)context, Actual.actual(data)));
    }

    public RuntimeContextBuilder registerSchema(String name, BiFunction<Data, DALRuntimeContext, Boolean> predicate) {
        this.valueConstructors.put(name, (o, context) -> {
            if (((Boolean)predicate.apply((Data)o, (DALRuntimeContext)context)).booleanValue()) {
                return o.getInstance();
            }
            throw new IllegalTypeException();
        });
        return this;
    }

    public <T> RuntimeContextBuilder registerPropertyAccessor(Class<T> type, PropertyAccessor<? extends T> propertyAccessor) {
        this.propertyAccessors.put(type, propertyAccessor);
        return this;
    }

    public <T> RuntimeContextBuilder registerListAccessor(Class<T> type, ListAccessor<? extends T> listAccessor) {
        this.listAccessors.put(type, listAccessor);
        return this;
    }

    public RuntimeContextBuilder registerSchema(NameStrategy nameStrategy, Class<? extends Schema> schema) {
        return this.registerSchema(nameStrategy.toName(schema), schema);
    }

    public RuntimeContextBuilder registerStaticMethodExtension(Class<?> staticMethodExtensionClass) {
        Stream.of(staticMethodExtensionClass.getMethods()).filter(method -> method.getParameterCount() >= 1 && (8 & method.getModifiers()) != 0).forEach(this.extensionMethods::add);
        return this;
    }

    public <T> RuntimeContextBuilder registerImplicitData(Class<T> type, Function<T, Object> mapper) {
        this.objectImplicitMapper.put(type, mapper);
        return this;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public RuntimeContextBuilder setConverter(Converter converter) {
        this.converter = converter;
        return this;
    }

    public RuntimeContextBuilder registerUserDefinedLiterals(UserLiteralRule rule) {
        this.userDefinedLiterals.add(rule);
        return this;
    }

    public RuntimeContextBuilder registerCurryingMethodRange(Method method, BiFunction<Object, List<Object>, List<Object>> range) {
        this.curryingMethodArgRanges.put(method, range);
        return this;
    }

    private Set<Method> methodToCurrying(Class<?> type, Object methodName) {
        return Stream.of(Arrays.stream(type.getMethods()).filter(method -> !Modifier.isStatic(method.getModifiers())).filter(method -> method.getName().equals(methodName)), this.staticMethodsToCurrying(type, methodName, Object::equals), this.staticMethodsToCurrying(type, methodName, Class::isAssignableFrom)).flatMap(Function.identity()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Stream<Method> staticMethodsToCurrying(Class<?> type, Object property, BiPredicate<Class<?>, Class<?>> condition) {
        return this.extensionMethods.stream().filter(method -> RuntimeContextBuilder.staticExtensionMethodName(method).equals(property)).filter(method -> condition.test(method.getParameters()[0].getType(), type));
    }

    static String staticExtensionMethodName(Method method) {
        ExtensionName extensionName = method.getAnnotation(ExtensionName.class);
        return extensionName != null ? extensionName.value() : method.getName();
    }

    BiFunction<Object, List<Object>, List<Object>> fetchCurryingMethodArgRange(Method method) {
        return this.curryingMethodArgRanges.get(method);
    }

    public RuntimeContextBuilder registerMatchesChecker(Class<?> type, Checker checker) {
        this.matchesCheckers.put(type, checker);
        return this;
    }

    public RuntimeContextBuilder registerEqualsChecker(Class<?> type, Checker checker) {
        this.equalsCheckers.put(type, checker);
        return this;
    }

    public RuntimeContextBuilder registerValueInspector(Class<?> ... types) {
        for (Class<?> type : types) {
            this.registerInspector(type, ValueInspector::new);
        }
        return this;
    }

    public RuntimeContextBuilder registerInspector(Class<?> type, InspectorBuilder builder) {
        this.inspectorBuilders.put(type, builder);
        return this;
    }

    public class DALRuntimeContext
    implements RuntimeContext {
        private final LinkedList<Data> stack = new LinkedList();
        private final Map<Data, PartialPropertyStack> partialPropertyStacks;

        public DALRuntimeContext(Object inputValue) {
            this.stack.push(this.wrap(inputValue));
            this.partialPropertyStacks = new HashMap<Data, PartialPropertyStack>();
        }

        public Data getThis() {
            return this.stack.getFirst();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T newBlockScope(Data data, Supplier<T> supplier) {
            try {
                this.stack.push(data);
                T t = supplier.get();
                return t;
            }
            finally {
                this.stack.pop();
            }
        }

        public Optional<ConstructorViaSchema> searchValueConstructor(String type) {
            return Optional.ofNullable(RuntimeContextBuilder.this.valueConstructors.get(type));
        }

        public Set<Object> findPropertyReaderNames(Object instance) {
            return ((PropertyAccessor)RuntimeContextBuilder.this.propertyAccessors.getData(instance)).getPropertyNames(instance);
        }

        public Boolean isNull(Object instance) {
            return RuntimeContextBuilder.this.propertyAccessors.tryGetData(instance).map(f -> f.isNull(instance)).orElseGet(() -> Objects.equals(instance, null));
        }

        public Object getPropertyValue(Data data, Object property) {
            PropertyAccessor propertyAccessor = (PropertyAccessor)RuntimeContextBuilder.this.propertyAccessors.getData(data.getInstance());
            try {
                return propertyAccessor.getValueByData(data, property);
            }
            catch (InvalidPropertyException e) {
                return data.currying(property).orElseThrow(() -> e).resolve();
            }
            catch (InvocationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvocationException((Throwable)e);
            }
        }

        public Iterable<Object> getList(Object instance) {
            return RuntimeContextBuilder.this.listAccessors.tryGetData(instance).map(l -> l.toIterable(instance)).orElseGet(() -> this.arrayIterable(instance));
        }

        public int getListFirstIndex(Object instance) {
            return RuntimeContextBuilder.this.listAccessors.tryGetData(instance).map(listAccessor -> listAccessor.firstIndex(instance)).orElse(0);
        }

        private Iterable<Object> arrayIterable(final Object instance) {
            return () -> new Iterator<Object>(){
                private final int length;
                private int index;
                {
                    this.length = Array.getLength(instance);
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.length;
                }

                @Override
                public Object next() {
                    return Array.get(instance, this.index++);
                }
            };
        }

        public boolean isRegisteredList(Object instance) {
            return RuntimeContextBuilder.this.listAccessors.tryGetData(instance).map(listAccessor -> listAccessor.isList(instance)).orElse(false);
        }

        public Converter getConverter() {
            return RuntimeContextBuilder.this.converter;
        }

        public Data wrap(Object instance) {
            return new Data(instance, this, SchemaType.createRoot());
        }

        public Data wrap(Object instance, String schema, boolean isList) {
            BeanClass schemaBeanClass = (BeanClass)RuntimeContextBuilder.this.schemas.get(schema);
            if (isList) {
                schemaBeanClass = BeanClass.create(Array.newInstance(schemaBeanClass.getType(), 0).getClass());
            }
            return new Data(instance, this, SchemaType.create(schemaBeanClass));
        }

        public <T> DALRuntimeContext registerPropertyAccessor(T instance) {
            if (!Objects.equals(instance, null) && !RuntimeContextBuilder.this.propertyAccessors.containsType(instance)) {
                RuntimeContextBuilder.this.propertyAccessors.put(BeanClass.getClass(instance), new JavaClassPropertyAccessor(BeanClass.createFrom(instance)));
            }
            return this;
        }

        public Optional<Result> takeUserDefinedLiteral(String token) {
            return RuntimeContextBuilder.this.userDefinedLiterals.stream().map(userLiteralRule -> userLiteralRule.compile(token)).filter(Result::hasResult).findFirst();
        }

        public void appendPartialPropertyReference(Data data, Object symbol) {
            this.fetchPartialProperties(data).map(partialProperties -> partialProperties.appendPartialProperties(symbol));
        }

        private Optional<PartialProperties> fetchPartialProperties(Data data) {
            return this.partialPropertyStacks.values().stream().map(partialPropertyStack -> partialPropertyStack.fetchPartialProperties(data)).filter(Objects::nonNull).findFirst();
        }

        public void initPartialPropertyStack(Data instance, Object prefix, Data partial) {
            this.partialPropertyStacks.computeIfAbsent(instance, _key -> this.fetchPartialProperties(instance).map(partialProperties -> partialProperties.partialPropertyStack).orElseGet(PartialPropertyStack::new)).setupPartialProperties(prefix, partial);
        }

        public Set<String> collectPartialProperties(Data instance) {
            PartialPropertyStack partialPropertyStack = this.partialPropertyStacks.get(instance);
            if (partialPropertyStack != null) {
                return partialPropertyStack.collectPartialProperties(instance);
            }
            return this.fetchPartialProperties(instance).map(partialProperties -> partialProperties.partialPropertyStack.collectPartialProperties(instance)).orElse(Collections.emptySet());
        }

        public NumberType getNumberType() {
            return RuntimeContextBuilder.this.numberType;
        }

        public Optional<Object> getImplicitObject(Object obj) {
            return RuntimeContextBuilder.this.objectImplicitMapper.tryGetData(obj).map(mapper -> mapper.apply(obj));
        }

        public Set<Method> methodToCurrying(Class<?> type, Object methodName) {
            return RuntimeContextBuilder.this.methodToCurrying(type, methodName);
        }

        public Function<MetaData, Object> fetchMetaFunction(DALNode property) {
            return RuntimeContextBuilder.this.metaProperties.computeIfAbsent(property.getRootSymbolName(), k -> {
                throw new RuntimeException(String.format("Meta property `%s` not found", property.getRootSymbolName()), property.getPositionBegin());
            });
        }

        public TextFormatter fetchFormatter(String name, int position) {
            return RuntimeContextBuilder.this.textFormatterMap.computeIfAbsent(name, attribute -> {
                throw new SyntaxException(String.format("Invalid text formatter `%s`, all supported formatters are:\n%s", attribute, RuntimeContextBuilder.this.textFormatterMap.entrySet().stream().map(e -> String.format("  %s:\n    %s", e.getKey(), ((TextFormatter)e.getValue()).description())).collect(Collectors.joining("\n"))), position);
            });
        }

        public Checker fetchEqualsChecker(ExpectActual expectActual) {
            return RuntimeContextBuilder.this.equalsCheckers.tryGetData(expectActual.getExpectInstance()).orElse(ConditionalChecker.EQUALS_CHECKER);
        }

        public Checker fetchMatchesChecker(ExpectActual expectActual) {
            return RuntimeContextBuilder.this.matchesCheckers.tryGetData(expectActual.getExpectInstance()).orElseGet(expectActual::defaultMatchesChecker);
        }

        public Inspector fetchInspector(Data data) {
            return (Inspector)RuntimeContextBuilder.this.inspectorBuilders.tryGetData(data.getInstance()).orElseGet(() -> Inspector::defaultInspector).apply(data);
        }
    }
}

