/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.SortSymbolNode;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SortGroupNode
extends DALNode {
    public static final Comparator<Object> NOP_COMPARATOR = (o1, o2) -> 0;
    public static final SortGroupNode NO_SEQUENCE = new SortGroupNode(Collections.emptyList()){

        @Override
        public Comparator<Object> comparator(Function<Object, Object> orderBy) {
            return NOP_COMPARATOR;
        }
    };
    private final List<SortSymbolNode> sortSymbolNodes;

    public SortGroupNode(List<DALNode> nodes) {
        this.sortSymbolNodes = nodes.stream().map(SortSymbolNode.class::cast).collect(Collectors.toList());
    }

    public static SortGroupNode noSequence() {
        return NO_SEQUENCE;
    }

    @Override
    public String inspect() {
        return !this.sortSymbolNodes.isEmpty() ? this.sortSymbolNodes.stream().map(SortSymbolNode::inspect).collect(Collectors.joining("", "", " ")) : "";
    }

    public Comparator<Object> comparator(Function<Object, Object> orderBy) {
        return this.sortSymbolNodes.get(0).getType().azOrZa(Comparator.comparing(o -> (Comparable)orderBy.apply(o)));
    }

    public static Comparator<SortGroupNode> comparator() {
        return Comparator.comparingInt(sequenceNode -> sequenceNode.sortSymbolNodes.size());
    }
}

