/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.runtime.Calculator;
import com.github.leeonky.dal.runtime.Checker;
import com.github.leeonky.dal.runtime.ConditionalChecker;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.util.TextUtil;
import com.github.leeonky.interpreter.StringWithPosition;

public class ExpectActual {
    private final Data expected;
    private final Data actual;

    public Data getActual() {
        return this.actual;
    }

    public Data getExpected() {
        return this.expected;
    }

    public ExpectActual(Data expected, Data actual) {
        this.expected = expected;
        this.actual = actual;
    }

    public boolean objectNotEquals() {
        return !Calculator.equals(this.actual, this.expected);
    }

    public boolean actualNotNull() {
        return !this.actual.isNull();
    }

    public boolean isInstanceOf(Class<?> actualType, Class<?> expectType) {
        return actualType.isInstance(this.actual.getInstance()) && expectType.isInstance(this.expected.getInstance());
    }

    public boolean isAllNumber() {
        return this.expected.getInstance() instanceof Number && this.actual.getInstance() instanceof Number;
    }

    public Data convertToExpectedType() {
        return this.actual.convert(this.expected.getInstance().getClass());
    }

    public Object getExpectInstance() {
        return this.expected.getInstance();
    }

    public boolean expectNull() {
        return this.expected.isNull();
    }

    public boolean equalTo(Data actual) {
        return Calculator.equals(actual, this.expected);
    }

    public boolean numberNotEquals() {
        return this.getExpected().numberNotEquals(this.getActual());
    }

    public String notationEqualTo() {
        return this.verificationMessage("Expected to be equal to: ");
    }

    public String notationNumberMatch() {
        return String.format("Expected to match: %s\nActual: %s", this.expected.inspect(), this.actual.inspect());
    }

    public String notationMatch() {
        return this.verificationMessage("Expected to match: ");
    }

    public String verificationMessage(String prefix) {
        return this.verificationMessage(prefix, "");
    }

    public String notationMatch(Data converted) {
        return converted.getInstance() == this.actual.getInstance() ? this.notationMatch() : this.verificationMessage("Expected to match: ", converted.inspect() + " converted from: ");
    }

    public String verificationMessage(String prefix, String actualPrefix) {
        String actual = actualPrefix + this.actual.inspect();
        String expected = this.expected.inspect();
        int position = TextUtil.differentPosition(expected, actual);
        String firstPart = new StringWithPosition(expected).position(position).result(prefix);
        return new StringWithPosition(actual).position(position).result(firstPart + "\nActual: ");
    }

    public String cannotCompare() {
        return String.format("Cannot compare between %s\nand %s", this.actual.inspect(), this.expected.inspect());
    }

    Checker defaultMatchesChecker() {
        if (this.expectNull()) {
            return ConditionalChecker.MATCH_NULL_CHECKER;
        }
        if (this.isAllNumber()) {
            return ConditionalChecker.MATCH_NUMBER_CHECKER;
        }
        return ConditionalChecker.MATCH_CHECKER;
    }
}

