/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.PartialProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

class PartialPropertyStack {
    private final Map<Data, PartialProperties> partials = new HashMap<Data, PartialProperties>();

    PartialPropertyStack() {
    }

    public void setupPartialProperties(Object prefix, Data partial) {
        this.partials.put(partial, new PartialProperties(prefix, partial));
    }

    public PartialProperties fetchPartialProperties(Data instance) {
        PartialProperties partialProperties = this.partials.get(instance);
        if (partialProperties == null) {
            partialProperties = this.partials.values().stream().map(sub -> sub.partialPropertyStack.fetchPartialProperties(instance)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return partialProperties;
    }

    public Set<String> collectPartialProperties(Data data) {
        return this.partials.values().stream().flatMap(partialProperties -> partialProperties.collectPartialProperties(data).stream()).collect(Collectors.toSet());
    }
}

