/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime.schema;

import com.github.leeonky.dal.compiler.Compiler;
import com.github.leeonky.dal.format.Formatter;
import com.github.leeonky.dal.format.Type;
import com.github.leeonky.dal.format.Value;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.SchemaAssertionFailure;
import com.github.leeonky.dal.runtime.schema.Verification;
import com.github.leeonky.dal.type.Schema;
import com.github.leeonky.dal.type.SubType;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.Classes;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class Actual {
    private final String property;
    private final Data actual;
    private static final Compiler compiler = new Compiler();

    public Actual(String property, Data actual) {
        this.property = property;
        this.actual = actual;
    }

    public static Actual actual(Data data) {
        return new Actual("", data);
    }

    public Actual sub(Object property) {
        return new Actual(this.property + "." + property, this.actual.getValue(property));
    }

    public boolean isNull() {
        return this.actual.isNull();
    }

    public Actual sub(Integer index) {
        return new Actual(this.property + "[" + index + "]", this.actual.getValue(index));
    }

    public Class<Object> polymorphicSchemaType(Class<?> schemaType) {
        return Optional.ofNullable(schemaType.getAnnotation(SubType.class)).map(subType -> {
            Object subTypeProperty = this.actual.getValue(compiler.toChainNodes(subType.property())).getInstance();
            return Stream.of(subType.types()).filter(t -> t.value().equals(subTypeProperty)).map(SubType.Type::type).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Cannot guess sub type through property type value[%s]", subTypeProperty)));
        }).orElse(schemaType);
    }

    public IllegalStateException invalidGenericType() {
        return new IllegalStateException(String.format("%s should specify generic type", this.property));
    }

    public boolean convertAble(BeanClass<?> type, String inspect) {
        if (this.isNull()) {
            return Verification.errorLog("Can not convert null field `%s` to %s, use @AllowNull to verify nullable field", this.property, inspect);
        }
        try {
            this.actual.convert(type.getType());
            return true;
        }
        catch (Exception ignore) {
            return Verification.errorLog("Can not convert field `%s` (%s: %s) to %s", this.property, Classes.getClassName((Object)this.actual.getInstance()), this.actual.getInstance(), inspect);
        }
    }

    public boolean verifyValue(Value<Object> value, BeanClass<?> type) {
        return value.verify(value.convertAs(this.actual, type)) || Verification.errorLog(value.errorMessage(this.property, this.actual.getInstance()), new Object[0]);
    }

    public Stream<Object> fieldNames() {
        return this.actual.getFieldNames().stream();
    }

    public Stream<Integer> indexStream() {
        return IntStream.range(0, this.actual.getListSize()).boxed();
    }

    public boolean verifyFormatter(Formatter<Object, Object> formatter) {
        return formatter.isValid(this.actual.getInstance()) || Verification.errorLog("Expected field `%s` to be formatter `%s`\nActual: %s", this.property, formatter.getFormatterName(), this.actual.inspect());
    }

    boolean verifySize(Function<Actual, Stream<?>> actualStream, int expectSize) {
        return actualStream.apply(this).count() == (long)expectSize || Verification.errorLog("Expected field `%s` to be size <%d>, but was size <%d>", this.property, expectSize, actualStream.apply(this).count());
    }

    boolean verifyType(Type<Object> expect) {
        return expect.verify(this.actual.getInstance()) || Verification.errorLog(expect.errorMessage(this.property, this.actual.getInstance()), new Object[0]);
    }

    boolean inInstanceOf(BeanClass<?> type) {
        return type.isInstance(this.actual.getInstance()) || Verification.errorLog(String.format("Expected field `%s` to be %s\nActual: %s", this.property, type.getName(), this.actual.inspect()), new Object[0]);
    }

    public boolean equalsExpect(Object expect) {
        return Objects.equals(expect, this.actual.getInstance()) || Verification.errorLog(String.format("Expected field `%s` to be %s\nActual: %s", this.property, this.inspect(expect), this.actual.inspect()), new Object[0]);
    }

    public String inspect(Object obj) {
        return obj == null ? "null " : String.format("%s\n<%s>", Classes.getClassName((Object)obj), obj);
    }

    public void verifySchema(Schema expect) {
        try {
            expect.verify(this.actual);
        }
        catch (SchemaAssertionFailure schemaAssertionFailure) {
            Verification.errorLog(schemaAssertionFailure.getMessage(), new Object[0]);
        }
    }
}

