/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal;

import com.github.leeonky.dal.DAL;
import com.github.leeonky.interpreter.InterpreterException;
import java.util.function.Supplier;

public class Assertions {
    private final Object input;
    public static boolean dumpInput = true;
    private DAL dal;
    private static Supplier<DAL> dalFactory = DAL::getInstance;

    public static void setDalFactory(Supplier<DAL> dalFactory) {
        Assertions.dalFactory = dalFactory;
    }

    public static void dumpInput(boolean enable) {
        dumpInput = enable;
    }

    private Assertions(Object input) {
        this.input = input;
        this.dal = dalFactory.get();
    }

    public Assertions use(DAL dal) {
        this.dal = dal;
        return this;
    }

    public static Assertions expect(Object input) {
        return new Assertions(input);
    }

    public Assertions should(String dalExpression) {
        return this.should("", dalExpression);
    }

    public Assertions should(String prefix, String verification) {
        String fullCode = prefix + verification;
        try {
            this.dal.evaluate(this.input, fullCode);
        }
        catch (InterpreterException e) {
            String detailMessage = "\n" + e.show(fullCode, prefix.length()) + "\n\n" + e.getMessage();
            if (dumpInput) {
                detailMessage = detailMessage + "\n\nThe root value was: " + this.dal.getRuntimeContextBuilder().build(null).wrap(this.input).dumpAll();
            }
            throw new AssertionError((Object)detailMessage);
        }
        return this;
    }

    public void exact(String verification) {
        this.should("=", verification);
    }

    public void match(String verification) {
        this.should(":", verification);
    }
}

