/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.ast.SortGroupNode;
import com.github.leeonky.dal.runtime.AutoMappingList;
import com.github.leeonky.dal.runtime.CurryingMethod;
import com.github.leeonky.dal.runtime.PartialObject;
import com.github.leeonky.dal.runtime.PropertyAccessException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.dal.runtime.SchemaType;
import com.github.leeonky.dal.runtime.SchemaVerifier;
import com.github.leeonky.interpreter.FunctionUtil;
import com.github.leeonky.util.BeanClass;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class Data {
    private final SchemaType schemaType;
    private final RuntimeContextBuilder.DALRuntimeContext dalRuntimeContext;
    private final Object instance;
    private List<Object> listValue;
    private Comparator<Object> listComparator = SortGroupNode.NOP_COMPARATOR;

    public Data(Object instance, RuntimeContextBuilder.DALRuntimeContext context, SchemaType schemaType) {
        this.instance = instance;
        this.schemaType = schemaType;
        this.dalRuntimeContext = context.registerPropertyAccessor(instance);
    }

    public String inspect() {
        return this.isNull() ? "null " : String.format("%s\n<%s>\n", BeanClass.getClassName((Object)this.getInstance()), this.getInstance());
    }

    public Object getInstance() {
        return this.instance;
    }

    public Set<Object> getFieldNames() {
        return this.dalRuntimeContext.findPropertyReaderNames(this.instance);
    }

    public boolean isList() {
        return this.dalRuntimeContext.isRegisteredList(this.instance) || this.instance != null && this.instance.getClass().isArray();
    }

    public int getListSize() {
        return this.getValueList().size();
    }

    public List<Object> getValueList() {
        return this.listValue == null ? (this.listValue = StreamSupport.stream(this.dalRuntimeContext.getList(this.instance).spliterator(), false).sorted(this.listComparator).collect(Collectors.toList())) : this.listValue;
    }

    public List<Data> getDataList() {
        AtomicInteger index = new AtomicInteger(0);
        return this.getValueList().stream().map(object -> new Data(object, this.dalRuntimeContext, this.schemaType.access(index.incrementAndGet()))).collect(Collectors.toList());
    }

    public boolean isNull() {
        return this.dalRuntimeContext.isNull(this.instance);
    }

    public SchemaVerifier createSchemaVerifier() {
        return new SchemaVerifier(this.dalRuntimeContext, this);
    }

    public Data getValue(List<Object> propertyChain) {
        return propertyChain.isEmpty() ? this : this.getValue(propertyChain.get(0)).getValue(propertyChain.subList(1, propertyChain.size()));
    }

    public Data getValue(Object propertyChain) {
        try {
            List<Object> chain = this.schemaType.access(propertyChain).getPropertyChainBefore(this.schemaType);
            if (chain.size() == 1 && chain.get(0).equals(propertyChain)) {
                return new Data(this.getPropertyValue(propertyChain), this.dalRuntimeContext, this.propertySchema(propertyChain));
            }
            return this.getValue(chain);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new PropertyAccessException("Index out of bounds (" + ex.getMessage() + "), first index is: " + this.getListFirstIndex(), ex);
        }
        catch (Exception e) {
            throw new PropertyAccessException(String.format("Get property `%s` failed, property can be:\n  1. public field\n  2. public getter\n  3. public no args method\n  4. Map key value\n  5. customized type getter\n  6. static method extension\n%s%s", propertyChain, e.getMessage(), this.listMappingMessage(this, propertyChain)), e);
        }
    }

    private String listMappingMessage(Data data, Object symbol) {
        return data.isList() ? String.format("\nImplicit list mapping is not allowed in current version of DAL, use `%s[]` instead", symbol) : "";
    }

    private Object getPropertyValue(Object property) {
        return this.isList() ? this.fetchFromList(property) : this.dalRuntimeContext.getPropertyValue(this, property);
    }

    private Object fetchFromList(Object property) {
        if (property instanceof String) {
            return this.dalRuntimeContext.getPropertyValue(this, property);
        }
        if ((Integer)property < 0) {
            return this.getValueList().get(this.getListSize() + (Integer)property);
        }
        return this.getValueList().get((Integer)property - this.getListFirstIndex());
    }

    public int getListFirstIndex() {
        return this.dalRuntimeContext.getListFirstIndex(this.instance);
    }

    private SchemaType propertySchema(Object property) {
        if (this.isList() && property instanceof String) {
            return this.schemaType.mappingAccess(property);
        }
        return this.schemaType.access(property);
    }

    public Object firstFieldFromAlias(Object alias) {
        return this.schemaType.firstFieldFromAlias(alias);
    }

    public Data convert(Class<?> target) {
        return new Data(this.dalRuntimeContext.getConverter().convert(target, this.instance), this.dalRuntimeContext, this.schemaType);
    }

    public Data setListComparator(Comparator<Object> listComparator) {
        this.listComparator = listComparator;
        return this;
    }

    public Data listMap(Object property) {
        return new Data(this.listMap((Data data) -> data.getValue(property).getInstance()), this.dalRuntimeContext, this.propertySchema(property));
    }

    public AutoMappingList listMap(Function<Data, Object> mapper) {
        return new AutoMappingList(this.getListFirstIndex(), this.getDataList(), mapper);
    }

    public Data filter(String prefix) {
        FilteredObject filteredObject = new FilteredObject();
        this.getFieldNames().stream().filter(String.class::isInstance).map(String.class::cast).filter((? super T field) -> field.startsWith(prefix)).forEach(fieldName -> filteredObject.put(this.trimPrefix(prefix, (String)fieldName), this.getValue(fieldName).getInstance()));
        return new Data(filteredObject, this.dalRuntimeContext, this.schemaType).setListComparator(this.listComparator);
    }

    private String trimPrefix(String prefix, String fieldName) {
        return fieldName.substring(prefix.length(), prefix.length() + 1).toLowerCase() + fieldName.substring(prefix.length() + 1);
    }

    public String dump() {
        return this.dump("", new HashMap<Object, String>(), "");
    }

    private String dump(String indentation, Map<Object, String> dumped, String path) {
        if (path.length() > 100) {
            return "\"** too deep level property!\"";
        }
        try {
            if (this.isList()) {
                return this.dumpList(indentation, dumped, path);
            }
            return this.dumpInstance(this.instance, indentation, dumped, path);
        }
        catch (Exception e) {
            return String.format("\"** Got exception during dump: %s\"", e);
        }
    }

    private String dumpInstance(Object instance, String indentation, Map<Object, String> dumped, String path) {
        return this.isNull() ? "null" : FunctionUtil.oneOf((Supplier[])new Supplier[]{() -> this.dalRuntimeContext.fetchSingleDumper(instance).map(dumper -> (String)dumper.apply(instance)), () -> this.dalRuntimeContext.fetchObjectDumper(instance).map(dumper -> this.dumpValueObject((Map)dumper.apply(instance), indentation))}).orElseGet(() -> this.dumpObject(indentation, dumped, path));
    }

    private String dumpList(String indentation, Map<Object, String> dumped, String path) {
        return this.getValueList().isEmpty() ? "[]" : this.fetchSameReference(dumped, path).orElseGet(() -> {
            StringJoiner joiner = new StringJoiner(", ", "[", "]");
            List<Data> listObjects = this.getDataList();
            for (int i = 0; i < listObjects.size(); ++i) {
                joiner.add(listObjects.get(i).dump(indentation, dumped, path + "[" + i + "]"));
            }
            return joiner.toString();
        });
    }

    private String dumpValueObject(Map<String, Object> instance, String indentation) {
        String keyIndentation = indentation + "  ";
        return instance.entrySet().stream().map(entry -> String.format("%s\"%s\": %s", keyIndentation, entry.getKey(), this.dumpInstance(entry.getValue(), keyIndentation, new HashMap<Object, String>(), (String)entry.getKey()))).collect(Collectors.joining(",\n", "{\n", "\n" + indentation + "}"));
    }

    private String dumpObject(String indentation, Map<Object, String> dumped, String path) {
        LinkedHashSet<Object> fieldNames = new LinkedHashSet<Object>(this.getFieldNames());
        return fieldNames.isEmpty() ? "{}" : this.fetchSameReference(dumped, path).orElseGet(() -> {
            String keyIndentation = indentation + "  ";
            List strings = fieldNames.stream().map(fieldName -> this.dumpField(dumped, path, keyIndentation, fieldName)).filter(Objects::nonNull).collect(Collectors.toList());
            if (!(this.instance instanceof Map)) {
                strings.add(String.format("%s\"%s\": %s", keyIndentation, "__type", "\"" + BeanClass.getClassName((Object)this.instance) + "\""));
            }
            return strings.stream().collect(Collectors.joining(",\n", "{\n", "\n" + indentation + "}"));
        });
    }

    private String dumpField(Map<Object, String> dumped, String path, String keyIndentation, Object fieldName) {
        String value;
        try {
            value = this.getValue(fieldName).dump(keyIndentation, dumped, path + "." + fieldName);
        }
        catch (PropertyAccessException e) {
            value = "\"** Got exception during dump: " + e.getCause() + "\"";
        }
        return String.format("%s%s: %s", keyIndentation, fieldName instanceof String ? String.format("\"%s\"", fieldName) : fieldName.toString(), value);
    }

    private Optional<String> fetchSameReference(Map<Object, String> dumped, String path) {
        String reference = dumped.get(this.instance);
        if (reference != null) {
            return Optional.of(String.format("\"** same with %s\"", reference.isEmpty() ? "root" : reference));
        }
        dumped.put(this.instance, path);
        return Optional.empty();
    }

    public <T> T newBlockScope(Supplier<T> supplier) {
        return this.dalRuntimeContext.newBlockScope(this, supplier);
    }

    public Optional<CurryingMethod> currying(Object property) {
        return this.currying(this.instance, property);
    }

    private Optional<CurryingMethod> currying(Object instance, Object property) {
        return FunctionUtil.oneOf((Supplier[])new Supplier[]{() -> this.dalRuntimeContext.methodToCurrying(instance.getClass(), property).map(method -> CurryingMethod.createCurryingMethod(instance, method)), () -> this.dalRuntimeContext.getImplicitObject(instance).flatMap(obj -> this.currying(obj, property))});
    }

    public Data requireList(int position) {
        if (this.isList()) {
            return this;
        }
        throw new RuntimeException(String.format("Invalid input value, expect a List but: %s", this.inspect()), position);
    }

    static class FilteredObject
    extends LinkedHashMap<String, Object>
    implements PartialObject {
        FilteredObject() {
        }
    }
}

