/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime.inspector;

import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.inspector.DumpingBuffer;
import com.github.leeonky.dal.runtime.inspector.ListDumper;
import com.github.leeonky.dal.runtime.inspector.MapDumper;
import com.github.leeonky.dal.runtime.inspector.StringDumper;
import com.github.leeonky.dal.runtime.inspector.ValueDumper;

public interface Dumper {
    public static final Dumper STRING_DUMPER = new StringDumper();
    public static final Dumper VALUE_INSPECTOR = new ValueDumper();
    public static final Dumper LIST_DUMPER = new ListDumper();
    public static final Dumper MAP_DUMPER = new MapDumper();

    public void dump(Data var1, DumpingBuffer var2);

    default public void dumpValue(Data data, DumpingBuffer dumpingBuffer) {
        this.dump(data, dumpingBuffer);
    }

    public static interface Cacheable
    extends Dumper {
        @Override
        default public void dump(Data data, DumpingBuffer context) {
            context.cached(data, () -> this.cachedInspect(data, context));
        }

        @Override
        default public void dumpValue(Data data, DumpingBuffer context) {
            context.cached(data, () -> this.cachedDump(data, context));
        }

        default public void cachedDump(Data data, DumpingBuffer context) {
            this.cachedInspect(data, context);
        }

        public void cachedInspect(Data var1, DumpingBuffer var2);
    }
}

