/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal;

import com.github.leeonky.dal.DAL;
import com.github.leeonky.interpreter.InterpreterException;

public class Assertions {
    private final Object input;
    private static DAL dal = DAL.getInstance();
    public static boolean dumpInput = true;

    public static void setDal(DAL dal) {
        Assertions.dal = dal;
    }

    public static void dumpInput(boolean enable) {
        dumpInput = enable;
    }

    private Assertions(Object input) {
        this.input = input;
    }

    public static Assertions expect(Object input) {
        return new Assertions(input);
    }

    public <T> T should(String dalExpression) {
        return this.should("", dalExpression);
    }

    public <T> T get(String dalExpression) {
        return this.should(dalExpression);
    }

    public <T> T should(String prefix, String verification) {
        String fullCode = prefix + verification;
        try {
            return dal.evaluate(this.input, fullCode);
        }
        catch (InterpreterException e) {
            String detailMessage = "\n" + e.show(fullCode, prefix.length()) + "\n\n" + e.getMessage();
            if (dumpInput) {
                detailMessage = detailMessage + "\n\nThe root value was:\n" + dal.getRuntimeContextBuilder().build(null).wrap(this.input).dump();
            }
            throw new AssertionError((Object)detailMessage);
        }
    }

    public void exact(String verification) {
        this.should("=", verification);
    }

    public void match(String verification) {
        this.should(":", verification);
    }
}

