/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.AssertionFailure;
import com.github.leeonky.dal.ast.ConstNode;
import com.github.leeonky.dal.ast.DALExpression;
import com.github.leeonky.dal.ast.DALOperator;
import com.github.leeonky.dal.ast.MetaSymbolNode;
import com.github.leeonky.dal.ast.RegexNode;
import com.github.leeonky.dal.ast.SchemaComposeNode;
import com.github.leeonky.dal.ast.SchemaNode;
import com.github.leeonky.dal.ast.SymbolNode;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.interpreter.NodeBase;
import com.github.leeonky.interpreter.SyntaxException;
import com.github.leeonky.interpreter.Token;
import com.github.leeonky.util.NumberParser;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;

public abstract class DALNode
extends NodeBase<RuntimeContextBuilder.DALRuntimeContext, DALNode> {
    private static final NumberParser numberParser = new NumberParser();

    public static DALNode stringSymbol(DALNode dalNode) {
        return new SymbolNode(((ConstNode)dalNode).getValue(), SymbolNode.Type.STRING);
    }

    public static DALNode numberSymbol(DALNode dalNode) {
        return new SymbolNode(((ConstNode)dalNode).getValue(), SymbolNode.Type.NUMBER);
    }

    public static SymbolNode symbolNode(Token token) {
        return new SymbolNode(token.getContent(), SymbolNode.Type.SYMBOL);
    }

    public static SymbolNode metaSymbolNode(Token token) {
        return new MetaSymbolNode(token.getContent());
    }

    public static SchemaComposeNode schemas(List<DALNode> nodes) {
        return new SchemaComposeNode(nodes.stream().map(SchemaNode.class::cast).collect(Collectors.toList()), false);
    }

    public static SchemaComposeNode elementSchemas(List<DALNode> nodes) {
        return new SchemaComposeNode(nodes.stream().map(SchemaNode.class::cast).collect(Collectors.toList()), true);
    }

    public static SchemaNode schema(Token token) {
        return (SchemaNode)new SchemaNode(token.getContent()).setPositionBegin(token.getPosition());
    }

    public static DALNode bracketSymbolNode(DALNode node) {
        return new SymbolNode(((ConstNode)node).getValue(), SymbolNode.Type.BRACKET);
    }

    public static DALNode parenthesesNode(DALNode node) {
        return new DALExpression(null, new DALOperator.Parentheses(), node);
    }

    public static DALNode constString(List<DALNode> nodes) {
        return new ConstNode(DALNode.getString(nodes));
    }

    public static DALNode relaxString(Token token) {
        return new ConstNode(token.getContent().trim());
    }

    public static DALNode regex(List<DALNode> nodes) {
        return new RegexNode(DALNode.getString(nodes));
    }

    private static String getString(List<DALNode> nodes) {
        return nodes.stream().map(ConstNode.class::cast).map(ConstNode::getValue).map(Object::toString).collect(Collectors.joining());
    }

    public static DALNode constTrue(String token) {
        return new ConstNode(true);
    }

    public static DALNode constFalse(String token) {
        return new ConstNode(false);
    }

    public static DALNode constNull(String token) {
        return new ConstNode(null);
    }

    public static ConstNode constNumber(Token token) {
        return new ConstNode(numberParser.parse(token.getContent()));
    }

    public static ConstNode constInteger(Token token) {
        Class<?> type;
        Number number = numberParser.parse(token.getContent());
        if (number != null && ((type = number.getClass()).equals(Integer.class) || type.equals(Long.class) || type.equals(Short.class) || type.equals(Byte.class) || type.equals(BigInteger.class))) {
            return new ConstNode(number);
        }
        throw new SyntaxException("expect an integer", token.getPosition());
    }

    public Data evaluateData(RuntimeContextBuilder.DALRuntimeContext context) {
        return context.wrap(this.evaluate(context));
    }

    public Object evaluate(RuntimeContextBuilder.DALRuntimeContext context) {
        return this.evaluateData(context).getInstance();
    }

    public boolean verifyBy(DALNode expected, DALOperator.Equal operator, RuntimeContextBuilder.DALRuntimeContext context) {
        return expected.verify(this, operator, context);
    }

    public boolean verifyBy(DALNode expected, DALOperator.Matcher operator, RuntimeContextBuilder.DALRuntimeContext context) {
        return expected.verify(this, operator, context);
    }

    public boolean verify(DALNode actualNode, DALOperator.Equal operator, RuntimeContextBuilder.DALRuntimeContext context) {
        return this.verify(actualNode.evaluateData(context), operator, context, actualNode);
    }

    public boolean verify(DALNode actualNode, DALOperator.Matcher operator, RuntimeContextBuilder.DALRuntimeContext context) {
        return this.verify(actualNode.evaluateData(context), operator, context, actualNode);
    }

    protected boolean verify(Data actual, DALOperator.Equal operator, RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        return AssertionFailure.assertEquals(this.evaluateData(context), actual, this.getPositionBegin());
    }

    protected boolean verify(Data actual, DALOperator.Matcher operator, RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        Data expected = this.evaluateData(context);
        if (expected.isNull()) {
            return AssertionFailure.assertMatchNull(actual, actualNode.getPositionBegin());
        }
        this.invalidTypeToMatchValue(String.class, actual, Number.class, expected, operator);
        this.invalidTypeToMatchValue(String.class, actual, Boolean.class, expected, operator);
        this.invalidTypeToMatchValue(Number.class, actual, String.class, expected, operator);
        this.invalidTypeToMatchValue(Boolean.class, actual, String.class, expected, operator);
        return AssertionFailure.assertMatch(expected, actual, this.getPositionBegin(), context.getNumberType());
    }

    public abstract String inspect();

    private void invalidTypeToMatchValue(Class<?> actualType, Data actual, Class<?> expectedType, Data expected, DALOperator.Matcher operator) {
        if (actualType.isInstance(actual.getInstance()) && expectedType.isInstance(expected.getInstance())) {
            throw new RuntimeException(String.format("Cannot compare between %sand %s", actual.inspect(), expected.inspect()).trim(), operator.getPosition());
        }
    }

    public Object getRootSymbolName() {
        return null;
    }

    public List<Object> propertyChain() {
        throw new IllegalStateException();
    }
}

