/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.DALOperator;
import com.github.leeonky.dal.ast.table.TableBody;
import com.github.leeonky.dal.ast.table.TableHeadRow;
import com.github.leeonky.dal.ast.table.TableRowNode;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RowAssertionFailure;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import java.util.List;
import java.util.stream.Collectors;

public class TableNode
extends DALNode {
    private final TableHeadRow headRow;
    private final TableBody tableBody;

    public TableNode(TableHeadRow headRow, TableBody tableBody) {
        this.headRow = headRow;
        this.tableBody = tableBody.checkFormat(this.headRow);
        this.setPositionBegin(headRow.getPositionBegin());
    }

    @Override
    protected boolean verify(Data actual, DALOperator.Equal operator, RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        try {
            return this.convertToVerificationNode(actual, operator, context).verify(actual, operator, context, actualNode);
        }
        catch (RowAssertionFailure rowAssertionFailure) {
            throw rowAssertionFailure.linePositionException(this);
        }
    }

    @Override
    protected boolean verify(Data actual, DALOperator.Matcher operator, RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        try {
            return this.convertToVerificationNode(actual, operator, context).verify(actual, operator, context, actualNode);
        }
        catch (RowAssertionFailure rowAssertionFailure) {
            throw rowAssertionFailure.linePositionException(this);
        }
    }

    public DALNode convertToVerificationNode(Data actual, DALOperator operator, RuntimeContextBuilder.DALRuntimeContext context) {
        return (DALNode)this.tableBody.convertToVerificationNode(actual, operator, this.headRow.collectComparator(context)).setPositionBegin(this.getPositionBegin());
    }

    @Override
    public String inspect() {
        return (this.headRow.inspect() + this.tableBody.inspect()).trim();
    }

    public static String printLine(List<? extends DALNode> nodes) {
        return nodes.stream().map(DALNode::inspect).collect(Collectors.joining(" | ", "| ", " |"));
    }

    public TableRowNode fetchDataRowSkipEllipsis(int indexSkipEllipsis) {
        return this.tableBody.dataRowSkipEllipsis(indexSkipEllipsis);
    }
}

