/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.table;

import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.DALOperator;
import com.github.leeonky.dal.ast.InputNode;
import com.github.leeonky.dal.ast.ListEllipsisNode;
import com.github.leeonky.dal.ast.ListScopeNode;
import com.github.leeonky.dal.ast.ObjectScopeNode;
import com.github.leeonky.dal.ast.SortGroupNode;
import com.github.leeonky.dal.ast.TableNode;
import com.github.leeonky.dal.ast.WildcardNode;
import com.github.leeonky.dal.ast.table.RowType;
import com.github.leeonky.dal.ast.table.TableDefaultIndexHeadRow;
import com.github.leeonky.dal.ast.table.TableHeadRow;
import com.github.leeonky.dal.ast.table.TableRowPrefixNode;
import com.github.leeonky.dal.runtime.DalException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.Clause;
import com.github.leeonky.interpreter.FunctionUtil;
import com.github.leeonky.interpreter.InterpreterException;
import com.github.leeonky.interpreter.Node;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class TableRowNode
extends DALNode {
    private final List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> cells;
    private final TableHeadRow tableHeadRow;
    private final TableRowPrefixNode rowPrefix;

    public TableRowNode(DALNode prefix, DALNode cell, TableHeadRow tableHeadRow) {
        this(prefix, Collections.singletonList(n -> cell), tableHeadRow);
    }

    public TableRowNode(DALNode prefix, List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> clauses, TableHeadRow tableHeadRow) {
        this.rowPrefix = (TableRowPrefixNode)prefix;
        this.cells = new ArrayList<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>>(clauses);
        this.tableHeadRow = tableHeadRow;
        this.setPositionBegin(clauses.get(clauses.size() - 1).getOperandPosition((Node)InputNode.INPUT_NODE));
    }

    @Override
    public String inspect() {
        String prefix = this.rowPrefix.inspect();
        String data = TableNode.printLine(this.cells.stream().map(clause -> (DALNode)clause.expression((Node)InputNode.INPUT_NODE)).collect(Collectors.toList()));
        return prefix.isEmpty() ? data : prefix + " " + data;
    }

    public Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode> constructVerificationClause(DALOperator operator, RowType rowType) {
        return input -> this.isEllipsis() ? this.firstCell() : this.rowPrefix.makeExpressionWithOptionalIndexAndSchema(rowType, (DALNode)input, operator, this.expectedRow());
    }

    private DALNode expectedRow() {
        if (this.isRowWildcard()) {
            return this.firstCell();
        }
        if (this.tableHeadRow instanceof TableDefaultIndexHeadRow) {
            return (DALNode)new ListScopeNode(this.cells, SortGroupNode.NOP_COMPARATOR, ListScopeNode.Style.ROW).setPositionBegin(this.getPositionBegin());
        }
        return (DALNode)new ObjectScopeNode(this.getCells()).setPositionBegin(this.getPositionBegin());
    }

    private DALNode firstCell() {
        return (DALNode)this.cells.get(0).expression(null);
    }

    private boolean isRowWildcard() {
        return this.cells.size() >= 1 && this.firstCell() instanceof WildcardNode;
    }

    private boolean isEllipsis() {
        return this.cells.size() >= 1 && this.firstCell() instanceof ListEllipsisNode;
    }

    private List<DALNode> getCells() {
        return new ArrayList<DALNode>(){
            {
                for (int i = 0; i < TableRowNode.this.cells.size(); ++i) {
                    this.add(((Clause)TableRowNode.this.cells.get(i)).expression((Node)TableRowNode.this.tableHeadRow.getHeader(i).property()));
                }
            }
        };
    }

    public TableRowNode merge(final TableRowNode rowNode) {
        return (TableRowNode)new TableRowNode((DALNode)this.rowPrefix, (List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>>)new ArrayList<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>>(){
            {
                this.addAll(TableRowNode.this.cells);
                this.addAll(rowNode.cells);
            }
        }, this.tableHeadRow.merge(rowNode.tableHeadRow)).setPositionBegin(this.getPositionBegin());
    }

    public boolean isData() {
        return !this.isEllipsis();
    }

    public boolean specialRow() {
        return this.isEllipsis() || this.isRowWildcard();
    }

    public RowType mergeRowTypeBy(RowType rowType) {
        return rowType.merge(this.rowPrefix.resolveRowType());
    }

    public void checkSize(int size) {
        if (!this.specialRow() && this.cells.size() != size) {
            throw new SyntaxException("Different cell size", this.cells.get(this.cells.size() - 1).getOperandPosition((Node)InputNode.INPUT_NODE));
        }
    }

    public DalException markPositionOnCells(DalException dalException) {
        return this.cells.stream().reduce(dalException, (e, cell) -> (DalException)e.multiPosition(((DALNode)cell.expression(null)).getPositionBegin(), InterpreterException.Position.Type.CHAR), FunctionUtil.notAllowParallelReduce());
    }
}

