/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.dal.ast.DALExpression;
import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.DALOperator;
import com.github.leeonky.dal.ast.GroupExpression;
import com.github.leeonky.dal.compiler.Notations;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.ExpressionFactory;
import com.github.leeonky.interpreter.Node;
import com.github.leeonky.interpreter.NodeParser;
import com.github.leeonky.interpreter.Operator;
import com.github.leeonky.interpreter.Procedure;
import com.github.leeonky.interpreter.RuntimeContext;
import com.github.leeonky.interpreter.SourceCode;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Supplier;

public class DALProcedure
extends Procedure<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> {
    private final LinkedList<Boolean> enableAndComma = new LinkedList<Boolean>(Collections.singleton(true));
    private boolean enableSlashProperty = false;
    private boolean enableRelaxProperty = false;
    private boolean enableNumberProperty = false;

    public DALProcedure(SourceCode sourceCode, RuntimeContextBuilder.DALRuntimeContext runtimeContext, ExpressionFactory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator> expressionFactory) {
        super(sourceCode, (RuntimeContext)runtimeContext, expressionFactory);
    }

    public static NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> disableCommaAnd(NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> nodeParser) {
        return procedure -> procedure.commaAnd(false, () -> nodeParser.parse(procedure));
    }

    public static NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> enableCommaAnd(NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> nodeParser) {
        return procedure -> procedure.commaAnd(true, () -> nodeParser.parse(procedure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Optional<T> commaAnd(boolean b, Supplier<Optional<T>> nodeFactory) {
        this.enableAndComma.push(b);
        try {
            Optional<T> optional = nodeFactory.get();
            return optional;
        }
        finally {
            this.enableAndComma.pop();
        }
    }

    public boolean isEnableCommaAnd() {
        return this.enableAndComma.getFirst();
    }

    public boolean isCodeBeginning() {
        return this.getSourceCode().isBeginning();
    }

    public boolean mayBeUnEqual() {
        return this.getSourceCode().startsWith(Notations.Operators.NOT_EQUAL);
    }

    public boolean mayBeOpeningGroup() {
        return this.getSourceCode().startsWith(Notations.OPENING_GROUP);
    }

    public boolean mayBeElementEllipsis() {
        return this.getSourceCode().startsWith("..");
    }

    public boolean isEnableSlashProperty() {
        return this.enableSlashProperty;
    }

    public boolean mayBeMetaProperty() {
        return this.getSourceCode().startsWith("::");
    }

    public static NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> enableSlashProperty(NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> nodeParser) {
        return procedure -> procedure.enableSlashProperty(() -> nodeParser.parse(procedure));
    }

    public static NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> enableSlashProperty(NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> mandatory) {
        return procedure -> procedure.enableSlashProperty(() -> (DALNode)((Object)((Object)((Object)mandatory.parse(procedure)))));
    }

    private <T> T enableSlashProperty(Supplier<T> supplier) {
        this.enableSlashProperty = true;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.enableSlashProperty = false;
        }
    }

    public boolean isEnableRelaxProperty() {
        return this.enableRelaxProperty;
    }

    public static NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> enableNumberProperty(NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> mandatory) {
        return procedure -> procedure.enableNumberProperty(() -> (DALNode)((Object)((Object)((Object)mandatory.parse(procedure)))));
    }

    private <T> T enableNumberProperty(Supplier<T> supplier) {
        this.enableNumberProperty = true;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.enableNumberProperty = false;
        }
    }

    public boolean isEnableNumberProperty() {
        return this.enableNumberProperty;
    }

    public static NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> enableRelaxProperty(NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> nodeParser) {
        return procedure -> procedure.enableRelaxProperty(() -> nodeParser.parse(procedure));
    }

    public static NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> enableRelaxProperty(NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> mandatory) {
        return procedure -> procedure.enableRelaxProperty(() -> (DALNode)((Object)((Object)((Object)mandatory.parse(procedure)))));
    }

    private <T> T enableRelaxProperty(Supplier<T> supplier) {
        this.enableRelaxProperty = true;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.enableRelaxProperty = false;
        }
    }

    public DALNode createExpression(DALNode left, DALOperator operator, DALNode right) {
        if (left instanceof GroupExpression) {
            return ((GroupExpression)left).append(operator, right, this);
        }
        if (right instanceof GroupExpression) {
            return ((GroupExpression)right).insert(left, operator, this);
        }
        return (DALNode)super.createExpression((Node)left, (Operator)operator, (Node)right);
    }
}

