/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.runtime.ElementAccessException;
import com.github.leeonky.dal.runtime.PropertyAccessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;

public class AutoMappingList
extends ArrayList<Object> {
    private final int firstIndex;

    public <T> AutoMappingList(int firstIndex, Collection<T> collection, Function<T, Object> mapper) {
        this.firstIndex = firstIndex;
        collection.forEach((? super T obj) -> {
            try {
                this.add(mapper.apply(obj));
            }
            catch (PropertyAccessException e) {
                throw new ElementAccessException(this.size() + this.firstIndex, e);
            }
            catch (Exception e) {
                throw new ElementAccessException(this.size() + this.firstIndex, new PropertyAccessException(e.getMessage(), e));
            }
        });
    }

    public int firstIndex() {
        return this.firstIndex;
    }
}

