/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.runtime.InstanceCurryingMethod;
import com.github.leeonky.util.Converter;
import com.github.leeonky.util.NumberType;
import com.github.leeonky.util.Suppressor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.stream.Collectors;

class StaticCurryingMethod
extends InstanceCurryingMethod {
    public StaticCurryingMethod(Object instance, Method method, Converter converter) {
        super(instance, method, converter);
    }

    @Override
    protected InstanceCurryingMethod clone() {
        return new StaticCurryingMethod(this.instance, this.method, this.converter);
    }

    @Override
    protected int parameterOffset() {
        return 1;
    }

    @Override
    public Object resolve() {
        return Suppressor.get(() -> this.method.invoke(null, this.parameterValues.stream().map(parameterValue -> parameterValue.getArg(this.converter)).collect(Collectors.toCollection(() -> new ArrayList<Object>(){
            {
                this.add(StaticCurryingMethod.this.instance);
            }
        })).toArray()));
    }

    @Override
    public boolean isSameInstanceType() {
        return this.method.getParameters()[0].getType().equals(NumberType.boxedClass(this.instance.getClass()));
    }
}

