/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.TableNode;
import com.github.leeonky.dal.ast.node.table.TransposedTableBody;
import com.github.leeonky.dal.ast.node.table.TransposedTableHead;
import com.github.leeonky.dal.ast.opt.Equal;
import com.github.leeonky.dal.ast.opt.Matcher;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RowAssertionFailure;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;

public class TransposedTableNode
extends DALNode {
    private final TransposedTableHead tableHead;
    private final TransposedTableBody tableBody;

    public TransposedTableNode(DALNode transposeTableHead, DALNode transposedTableBody) {
        this.tableHead = (TransposedTableHead)transposeTableHead;
        this.tableBody = ((TransposedTableBody)transposedTableBody).checkFormat(this.tableHead);
    }

    @Override
    protected boolean verify(Data actual, Matcher operator, RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        try {
            return this.transpose().convertToVerificationNode(actual, operator, context).verify(actual, operator, context, actualNode);
        }
        catch (RowAssertionFailure rowAssertionFailure) {
            throw rowAssertionFailure.columnPositionException(this);
        }
    }

    @Override
    protected boolean verify(Data actual, Equal operator, RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        try {
            return this.transpose().convertToVerificationNode(actual, operator, context).verify(actual, operator, context, actualNode);
        }
        catch (RowAssertionFailure rowAssertionFailure) {
            throw rowAssertionFailure.columnPositionException(this);
        }
    }

    public TableNode transpose() {
        return (TableNode)new TableNode(this.tableBody.transposeHead(), this.tableBody.transpose(this.tableHead)).setPositionBegin(this.getPositionBegin());
    }

    @Override
    public String inspect() {
        return this.tableHead.inspect() + this.tableBody.inspect();
    }
}

